<?php
    $locale = request()->locale ?? app()->getLocale();
    $translations = [];
    $bundle = $bundle ?? null;
    if ($bundle && $locale) {
        $translations = parse_translation($bundle, $locale);
    }
    $backendSetting = get_theme_option(key: 'backend_general') ?? null;
    $platformFee = $backendSetting['platform_fee'] ?? 0;
    $bundlePrice = isset($bundle) ? $bundle->price - $bundle->platform_fee : null;
    $isOrganization = isOrganization();
    $isAdmin = isAdmin();
?>


<div class="fieldset">
    <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="pricing">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="bundle_id" class="bundleId" value="<?php echo e($bundle->id ?? ''); ?>">
        <div class="grid grid-cols-12 gap-4 card">
            <div class="col-span-full lg:col-span-2">
                <div class="mt-6">
                    <label for="currency" class="form-label"><?php echo e(translate('Currency')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <select data-select id="currency" name="currency" class="singleSelect">
                        <option selected disabled data-display="<?php echo e(translate('Select Currency')); ?>">
                            <?php echo e(translate('Select Currency')); ?> </option>
                        <?php $__currentLoopData = all_currency(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $codeSymbol = $currency->code . '-' . $currency->symbol;
                            ?>
                            <option value="<?php echo e($currency->code . '-' . $currency->symbol); ?>"
                                <?php echo e(isset($bundle) && $bundle?->currency == $codeSymbol ? 'selected' : ''); ?>>
                                <?php echo e($currency->symbol); ?> - <?php echo e($currency->code); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <span class="text-danger error-text currency_err"></span>
                </div>
            </div>
            <div class="col-span-full lg:col-span-3">
                <div class="mt-6">
                    <label for="price" class="form-label"> <?php echo e(translate('Price')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <input type="number" placeholder="<?php echo e(translate('Your Price')); ?>"
                        class="form-input bundle-price-cal" value="<?php echo e($bundlePrice ?? ''); ?>" id="price">
                </div>
            </div>
            <div class="col-span-full lg:col-span-3">
                <div class="mt-6">
                    <label for="platform_fee" class="form-label">
                        <?php echo e(translate('Platform Price')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <input type="hidden"value="<?php echo e($platformFee ?? ''); ?>" name="platform_fee">
                    <input type="number" id="platform_fee" placeholder="<?php echo e(translate('Platform Price')); ?>" disabled
                        class="form-input disabled:!text-heading" value="<?php echo e($platformFee ?? ''); ?>"
                        placeholder="Platform Price">
                    <span class="text-danger error-text platform_fee_err"></span>
                </div>
            </div>
            <div class="col-span-full lg:col-span-3">
                <div class="mt-6">
                    <label for="total_price" class="form-label"><?php echo e(translate('Total Price')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <input type="number" id="total_price" placeholder="<?php echo e(translate('Bundle Price')); ?>" name="price"
                        class="form-input" value="<?php echo e($bundlePrice + $platformFee ?? ''); ?>">
                    <span class="text-danger error-text  price_err"></span>
                </div>
            </div>
        </div>
        <div class="card flex-center gap-4 justify-end">
            <button type="button" class="prev-form-btn btn b-outline btn-primary-outline">
                <?php echo e(translate('Previous')); ?>

            </button>
            <button type="button" class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                <?php echo e(translate('Save & Continue')); ?>

            </button>
        </div>
    </form>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\course\bundle\price-form.blade.php ENDPATH**/ ?>