<!-- Notice Board -->
<div class="fieldset">
    <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="noticeboard">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="course_id" class="courseId" value="<?php echo e($course->id ?? ''); ?>">
        <div class="grid grid-cols-12 gap-x-4">
            <div class="col-span-full lg:col-span-6 card p-3 sm:p-6">
                <h6 class="text-xl font-semibold text-heading"><?php echo e(translate('Notice Board')); ?></h6>
                <div class="mt-7">
                    <label for="notice-title" class="form-label"><?php echo e(translate('Title')); ?></label>
                    <input type="text" id="notice-title" class="form-input" placeholder="<?php echo e(translate('Title')); ?>"
                        name="notice_title" autocomplete="off" />
                    <span class="text-danger error-text notice_title_err"></span>
                </div>
                <div class="mt-4">
                    <label class="form-label"><?php echo e(translate('Notice Description')); ?></label>
                    <textarea class="summernote form-input" name="notice_description"></textarea>
                    <span class="text-danger error-text notice_description_err"></span>
                </div>
                <div class="flex items-center gap-2 peer/discount mt-10">
                    <input id="is-mailable" type="checkbox" name="is_mailable" class="check check-primary-solid">
                    <label for="is-mailable" class="form-label !m-0">
                        <?php echo e(translate('Do you want to mail this notice to all of your students?')); ?>

                    </label>
                </div>
            </div>
            <div class="col-span-full lg:col-span-6 card p-3 sm:p-6 relative">
                <h6 class="text-xl font-semibold text-heading"><?php echo e(translate('All Notice')); ?></h6>
                <?php if(isset($course, $course->courseNotes) && $course->courseNotes->count() > 0): ?>
                    <ul class="space-y-5 mt-7">
                        <?php $__currentLoopData = $course->courseNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseNote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="text-gray-500 dark:text-dark-text"><?php echo e($courseNote->title); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php else: ?>
                    <li class="position-center text-gray-500 dark:text-dark-text">
                        <?php echo e(translate('No Notice Available.')); ?></li>
                <?php endif; ?>
            </div>
        </div>

        <div class="card flex-center gap-4 justify-end">
            <button type="button" class="prev-form-btn btn b-outline btn-primary-outline">
                <?php echo e(translate('Previous')); ?>

            </button>
            <button type="button" class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                <?php echo e(translate('Save & Continue')); ?>

            </button>
        </div>
    </form>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\course\notice-board-form.blade.php ENDPATH**/ ?>