<h5 class="text-xl font-semibold text-heading dark:text-white mb-4">
    <?php echo e(translate('Contact')); ?>

</h5>
<ul class="space-y-2">
    <?php
        $userInfo = $user->userable ?? null;
    ?>
    <li>
        <span class="text-heading"><?php echo e(translate('Phone')); ?>:</span>
        <?php echo e($userInfo?->phone); ?>

    </li>
    <li>
        <span class="text-heading"><?php echo e(translate('Email')); ?>:</span>
        <a href="mailto:<?php echo e($user->email); ?>" class="text-primary"><?php echo e($user->email); ?></a>
    </li>

    <?php if(!empty($userInfo->city?->name) || !empty($userInfo?->state?->name) || !empty($userInfo?->country?->name)): ?>
        <li>
            <?php
                $city = $userInfo?->city?->name;
                $state = $userInfo?->state?->name;
                $country = $userInfo?->country?->name;
            ?>
            <span class="text-heading"><?php echo e(translate('Location')); ?>:</span>
            <?php echo e($city ? $city . ',' : ''); ?>

            <?php echo e($state ? $state . ',' : ''); ?>

            <?php echo e($country ? $country . '.' : ''); ?>

        </li>
    <?php endif; ?>
</ul>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\profile\contact\contact-info.blade.php ENDPATH**/ ?>