<?php
    if (!($subscription && is_object($subscription))) {
        return;
    }

    $translations = parse_translation($subscription);
    $title = $translations['title'] ?? ($subscription->title ?? '');
    $description = $translations['description'] ?? ($subscription->description ?? '');
    $iconImg =
        $subscription->icon_img && fileExists('lms/subscribes', $subscription->icon_img)
            ? asset("storage/lms/subscribes/{$subscription->icon_img}")
            : asset('lms/frontend/assets/images/450x300.svg');
?>
<div class="swiper-slide">
    <div class="flex flex-col bg-white h-full custom-transition p-4 xl:p-6 rounded-2xl group/blog">
        <!-- BLOG THUMBNAIL -->
        <div class="relative aspect-[1.6] rounded-lg overflow-hidden shrink-0">
            <div class="blog-thumb">
                <?php if($subscription->is_popular): ?>
                    <span><?php echo e(translate('Popular')); ?></span>
                <?php endif; ?>
                <img data-src="<?php echo e($iconImg); ?>" alt="Icon Image"
                    class="size-full object-cover group-hover/blog:scale-110 custom-transition">
            </div>
        </div>
        <!-- BLOG CONTENT -->
        <div class="pt-6 pb-2 grow">
            <h6 class="area-title font-bold !text-xl group-hover/blog:text-secondary mt-6 custom-transition">
                <?php echo e($title); ?>

            </h6>
            <div class="card-description mt-3 text-heading/70 line-clamp-2">
                <?php echo clean($description); ?>

            </div>
            <h5 class="area-title font-bold !text-xl group-hover/blog:text-secondary mt-6 custom-transition">
                $<?php echo e(dotZeroRemove($subscription->price)); ?>

            </h5>
            <div class="card-description mt-3 text-heading/70 line-clamp-2">
                <p> <?php echo e($subscription->usable_count); ?> subscribes </p>
                <p> <?php echo e($subscription->days); ?> days of subscriptions</p>
            </div>
            <?php if(!authCheck()): ?>
                <a title="purchase" href="<?php echo e(route('login')); ?>"
                    class="btn b-solid btn-primary-solid btn-xl !rounded-full font-medium text-[16px] md:text-[18px] mt-2">
                    Purchase
                </a>
            <?php else: ?>
                <form action="<?php echo e(route('subscription.payment')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" value="<?php echo e($subscription->id); ?>">
                    <button type="submit"
                        class="btn b-solid btn-primary-solid btn-xl !rounded-full font-medium text-[16px] md:text-[18px] mt-2">
                        Purchase
                    </button>
                </form>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\cards\subscribe\card-one.blade.php ENDPATH**/ ?>