<?php
    $locale = app()->getLocale();
    $courses = $courses ?? [];
?>
<div class="fieldset">
    <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="courses">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="bundle_id" class="Id" value="<?php echo e($bundle->id ?? ''); ?>">
        <div class="grid grid-cols-12 gap-x-4">
            <div class="col-span-full lg:col-span-6 card">
                <h6 class="text-xl font-semibold text-heading"><?php echo e(translate('Bundle')); ?></h6>
                <select class="multipleSelect form-input" multiple="multiple" name="courseId[]">
                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $courseTranslations = parse_translation($course, $locale); ?>
                        <option value="<?php echo e($course->id); ?>"
                            <?php if(isset($bundle) && $bundle?->courses?->count() > 0): ?> <?php $__currentLoopData = $bundle?->courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bcourse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e($bcourse->id == $course->id ? 'selected' : ''); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>>
                            <?php echo e($courseTranslations['title'] ?? ($course->title ?? '')); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <span class="text-danger error-text courseId_err"></span>
            </div>

            <?php if(module_enable_check('subscribe') || module_enable_check('certificate')): ?>
                <div class="col-span-full lg:col-span-6 card">
                    <h6 class="text-xl font-semibold text-heading"><?php echo e(translate('Bundle Settings Options')); ?>

                    </h6>
                    <div class="mt-10">

                        <?php if(module_enable_check('subscribe')): ?>
                            <div class="leading-none flex items-center gap-4 mb-10">
                                <label for="subscribe" class="inline-flex items-center me-5 cursor-pointer">
                                    <input type="checkbox" id="subscribe" name="is_subscribe"
                                        class="appearance-none peer"
                                        <?php echo e(isset($bundle) && $bundle?->is_subscribe == 1 ? 'checked' : ''); ?>>
                                    <div class="switcher switcher-primary-solid"></div>
                                </label>
                                <div class="text-gray-500 dark:text-dark-text font-medium inline-block">
                                    <?php echo e(translate('Subscribe')); ?></div>
                            </div>
                        <?php endif; ?>

                        <?php if(module_enable_check('certificate')): ?>
                            <div class="leading-none flex items-center gap-4 mb-10">
                                <label for="certificate" class="inline-flex items-center me-5 cursor-pointer">
                                    <input type="checkbox" id="certificate" name="is_certificate"
                                        class="appearance-none peer"
                                        <?php echo e(isset($bundle) && $bundle?->is_certificate == 1 ? 'checked' : ''); ?>>
                                    <div class="switcher switcher-primary-solid"></div>
                                </label>
                                <div class="text-gray-500 dark:text-dark-text font-medium inline-block">
                                    <?php echo e(translate('Has Certificate')); ?></div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>

        </div>
        <div class="card flex-center gap-4 justify-end">
            <button type="button"
                class="prev-form-btn btn b-outline btn-primary-outline"><?php echo e(translate('Previous')); ?></button>
            <button type="button"
                class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square"><?php echo e(translate('Save & Continue')); ?>

            </button>
        </div>
    </form>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\course\bundle\course-form.blade.php ENDPATH**/ ?>