<?php
    $backendSetting = get_theme_option(key: 'backend_general') ?? null;
    $currency = $backendSetting['currency'] ?? 'USD-$';
    $currencySymbol = get_currency_symbol($currency);
    $cartType = session()->has('type') ? session()->get('type') : '';
?>

<?php $__env->startPush('css'); ?>
    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    <script async src="https://sandbox.doku.com/jokul-checkout-js/v1/jokul-checkout-1.0.0.js"></script>
    <script src="https://js.stripe.com/v3/"></script>
    <script src="https://www.paypalobjects.com/api/checkout.js"></script>
<?php $__env->stopPush(); ?>

<?php if (isset($component)) { $__componentOriginal4ea3ceba530d619a977e9c813ff095c4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4ea3ceba530d619a977e9c813ff095c4 = $attributes; } ?>
<?php $component = Modules\LMS\View\Components\Frontend\Layout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('frontend-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Modules\LMS\View\Components\Frontend\Layout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <?php if (isset($component)) { $__componentOriginal633e9714cbfc155a1e1afb58682cfb8f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal633e9714cbfc155a1e1afb58682cfb8f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::breadcrumbs.breadcrumb-one','data' => ['pageTitle' => 'Checkout','pageRoute' => ''.e(route('checkout.page')).'','pageName' => 'Checkout']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::breadcrumbs.breadcrumb-one'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['pageTitle' => 'Checkout','pageRoute' => ''.e(route('checkout.page')).'','pageName' => 'Checkout']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal633e9714cbfc155a1e1afb58682cfb8f)): ?>
<?php $attributes = $__attributesOriginal633e9714cbfc155a1e1afb58682cfb8f; ?>
<?php unset($__attributesOriginal633e9714cbfc155a1e1afb58682cfb8f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal633e9714cbfc155a1e1afb58682cfb8f)): ?>
<?php $component = $__componentOriginal633e9714cbfc155a1e1afb58682cfb8f; ?>
<?php unset($__componentOriginal633e9714cbfc155a1e1afb58682cfb8f); ?>
<?php endif; ?>
    <div class="container">
        <?php echo csrf_field(); ?>
        <div class="grid grid-cols-12 gap-5">
            <!-- START FILTER SIDEBAR -->
            <div class="col-span-full lg:col-span-8">
                <h2 class="area-title xl:text-3xl mb-5"><?php echo e(translate('Payment Method')); ?></h2>
                <div class="dashkit-tab flex flex-wrap items-center gap-2.5" id="paymentMethodTab">
                    <?php $__currentLoopData = get_payment_method(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $logo =
                                $payment->logo && fileExists('lms/payments', $payment->logo) == true
                                    ? asset('storage/lms/payments/' . $payment->logo)
                                    : asset('lms/frontend/assets/images/payment-method/master-card.webp');
                        ?>
                        <button
                            class="dashkit-tab-btn btn border border-border btn-lg !px-8 h-14 !rounded-full [&.active]:border-primary payment-item"
                            data-method="<?php echo e(strtolower($payment->method_name)); ?>"
                            data-action ="<?php echo e(route('payment.form')); ?>">
                            <img data-src="<?php echo e($logo); ?>" alt="master card" class="w-20">
                        </button>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="dashkit-tab-content mt-[60px]" id="paymentMethodTabContent">
                    <!-- MASTER CARD FORM -->
                    <div class="dashkit-tab-pane">
                        <?php if (isset($component)) { $__componentOriginal9e05e2178cc5d33c3d1a97a50bea5f28 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9e05e2178cc5d33c3d1a97a50bea5f28 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::cards.empty','data' => ['title' => 'Select Payment']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::cards.empty'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Select Payment']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9e05e2178cc5d33c3d1a97a50bea5f28)): ?>
<?php $attributes = $__attributesOriginal9e05e2178cc5d33c3d1a97a50bea5f28; ?>
<?php unset($__attributesOriginal9e05e2178cc5d33c3d1a97a50bea5f28); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9e05e2178cc5d33c3d1a97a50bea5f28)): ?>
<?php $component = $__componentOriginal9e05e2178cc5d33c3d1a97a50bea5f28; ?>
<?php unset($__componentOriginal9e05e2178cc5d33c3d1a97a50bea5f28); ?>
<?php endif; ?>
                    </div>
                </div>
            </div>
            <!-- END FILTER SIDEBAR -->

            <!-- START TOTAL -->
            <div class="col-span-full lg:col-span-4">
                <div class="bg-primary-50 p-6 rounded-xl">
                    <h6 class="text-3xl text-heading dark:text-white !leading-none font-bold">
                        <?php echo e(translate('Your Order')); ?>

                    </h6>
                    <table class="w-full my-7">
                        <?php if($cartType !== 'subscription'): ?>
                            <caption
                                class="text-xl text-heading dark:text-white !leading-none font-bold text-left rtl:text-right mb-5">
                                <?php echo e(translate('Cart Total') . ' ' . total_qty()); ?>

                            </caption>
                        <?php endif; ?>
                        <tbody class="divide-y divide-border border-t border-border">
                            <tr>
                                <td class="px-1 py-4 text-left rtl:text-right">
                                    <div
                                        class="flex items-center gap-2 area-description text-heading/70 !leading-none shrink-0">
                                        <span
                                            class="text-heading dark:text-white mb-0.5"><?php echo e(translate('Subtotal')); ?></span>
                                    </div>
                                </td>
                                <td class="px-1 py-4 text-right rtl:text-left">
                                    <div class="text-heading/70 font-semibold leading-none">
                                        <?php echo e($currencySymbol); ?><?php echo e(number_format($data['totalPrice'], 2) ?? null); ?>

                                    </div>
                                </td>
                            </tr>
                            <?php if($data['discountAmount']): ?>
                                <tr>
                                    <td class="px-1 py-4 text-left rtl:text-right">
                                        <div
                                            class="flex items-center gap-2 area-description text-heading/70 !leading-none shrink-0">
                                            <span
                                                class="text-heading dark:text-white mb-0.5"><?php echo e(translate('Discount')); ?></span>
                                        </div>
                                    </td>
                                    <td class="px-1 py-4 text-right rtl:text-left">
                                        <div class="text-heading/70 font-semibold leading-none">
                                            <?php echo e($currencySymbol); ?><?php echo e($data['discountAmount']); ?></div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                            <tr>
                                <td class="px-1 py-4 text-left rtl:text-right">
                                    <div
                                        class="flex items-center gap-2 area-description text-heading/70 !leading-none shrink-0">
                                        <span
                                            class="text-heading dark:text-white text-lg font-bold mb-0.5"><?php echo e(translate('Total')); ?></span>
                                    </div>
                                </td>
                                <td class="px-1 py-4 text-right rtl:text-left">
                                    <div class="text-primary text-lg font-bold leading-none">
                                        <?php
                                            $totalPrice = $data['discountAmount']
                                                ? $data['totalPrice'] - $data['discountAmount']
                                                : $data['totalPrice'];
                                        ?>
                                        <?php echo e($currencySymbol); ?><?php echo e(number_format($totalPrice, 2)); ?>

                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <div id="pay-button">

                    </div>
                </div>
            </div>
            <!-- END TOTAL -->
        </div>
    </div>
    <!-- END INNER CONTENT AREA -->
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4ea3ceba530d619a977e9c813ff095c4)): ?>
<?php $attributes = $__attributesOriginal4ea3ceba530d619a977e9c813ff095c4; ?>
<?php unset($__attributesOriginal4ea3ceba530d619a977e9c813ff095c4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4ea3ceba530d619a977e9c813ff095c4)): ?>
<?php $component = $__componentOriginal4ea3ceba530d619a977e9c813ff095c4; ?>
<?php unset($__componentOriginal4ea3ceba530d619a977e9c813ff095c4); ?>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\theme\checkout\index.blade.php ENDPATH**/ ?>