<div class="relative pt-16 sm:pt-24 lg:pt-[120px]">
    <div class="container">
        <!-- HEADER -->
        <div class="grid grid-cols-12 gap-4 items-center">
            <div class="col-span-full text-center max-w-[640px] mx-auto">
                <h2 class="area-title">
                    <?php echo e(translate('The Work Process of Our')); ?>

                    <span class="title-highlight-two"><?php echo e(translate('kindergarten School')); ?></span>
                </h2>
            </div>
        </div>
        <!-- BODY -->
        <div class="swiper work-process-slider mt-10 lg:mt-[60px]">
            <div class="swiper-wrapper">
                <!-- SINGLE WORK PROCESS CARD -->
                <div class="swiper-slide">
                    <div class="bg-[#DEC8FE] px-9 pt-11 pb-24 h-full image-mask mask-work-process">
                        <div class="flex-center flex-col text-center">
                            <div class="size-14 rounded-50 flex-center bg-white p-2 shrink-0 image-mask mask-star">
                                <div
                                    class="font-secondary text-primary text-2xl !leading-none italic font-semibold -mb-1">
                                    01</div>
                            </div>
                            <h6 class="area-title text-xl !leading-none mt-5"><?php echo e(translate('Morning Circle Time')); ?>

                            </h6>
                            <div class="area-description text-base line-clamp-2 mt-3">
                                <?php echo e(translate("Children gather to discuss the day's plan, engage in songs, and share stories to build a sense of community and routine'")); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <!-- SINGLE WORK PROCESS CARD -->
                <div class="swiper-slide">
                    <div class="bg-[#FBD983] px-9 pt-11 pb-24 h-full image-mask mask-work-process">
                        <div class="flex-center flex-col text-center">
                            <div class="size-14 rounded-50 flex-center bg-white p-2 shrink-0 image-mask mask-star">
                                <div
                                    class="font-secondary text-primary text-2xl !leading-none italic font-semibold -mb-1">
                                    02 </div>
                            </div>
                            <h6 class="area-title text-xl !leading-none mt-5"><?php echo e(translate('Learning Through Play')); ?>

                            </h6>
                            <div class="area-description text-base line-clamp-2 mt-3">
                                <?php echo e(translate('Activities like puzzles, crafts, and role-playing encourage creativity, problem-solving, and motor skill development.')); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <!-- SINGLE WORK PROCESS CARD -->
                <div class="swiper-slide">
                    <div class="bg-[#D5EEB4] px-9 pt-11 pb-24 h-full image-mask mask-work-process">
                        <div class="flex-center flex-col text-center">
                            <div class="size-14 rounded-50 flex-center bg-white p-2 shrink-0 image-mask mask-star">
                                <div
                                    class="font-secondary text-primary text-2xl !leading-none italic font-semibold -mb-1">
                                    03 </div>
                            </div>
                            <h6 class="area-title text-xl !leading-none mt-5"><?php echo e(translate('Snack and Rest Period')); ?>

                            </h6>
                            <div class="area-description text-base line-clamp-2 mt-3">
                                <?php echo e(translate('Scheduled time for nutritious snacks and relaxation to recharge, promoting healthy habits and well-being.')); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\themes\kindergarten\components\work\process.blade.php ENDPATH**/ ?>