<?php
    $thumbnail =
        $bundle->thumbnail && fileExists('lms/courses/bundles', $bundle->thumbnail) == true
            ? asset("storage/lms/courses/bundles/{$bundle->thumbnail}")
            : asset('lms/frontend/assets/images/420x252.svg');
    $currency = $bundle?->currency ?? 'USD-$';
    $currencySymbol = get_currency_symbol($currency);
?>
<div class="col-span-full lg:col-span-4">
    <div class="bg-primary-50 p-6 rounded-2xl">
        <div data-modal-id="demo-video-modal"
            class="flex-center relative cursor-pointer w-full aspect-video rounded-2xl overflow-hidden">
            <img data-src="<?php echo e($thumbnail); ?>" alt="Course thumbnail" class="size-full object-cover">
            <!-- CONTROLLER -->
            <div class="flex-center size-full bg-[#D9D9D9]/30 rounded-2xl absolute inset-0 [&.hide]:invisible">
                <button type="button" aria-label="Open demo video modal button"
                    class="btn-icon size-9 b-solid btn-secondary-icon-solid !text-heading dark:text-white pulse-animation active:scale-105">
                    <i class="ri-play-fill text-base"></i>
                </button>
            </div>
        </div>
        <table class="w-full mt-7">
            <caption class="area-title text-xl text-left rtl:text-right"> <?php echo e(translate('This Bundle Includes')); ?>:
            </caption>
            <tbody class="divide-y divide-border mt-1">
                <tr>
                    <td class="px-1 py-4 text-right rtl:text-left">
                        <div class="text-heading dark:text-white font-semibold leading-none"><?php echo e($bundle->duration); ?>

                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="px-1 py-4 text-left rtl:text-right">
                        <div class="flex items-center gap-2 area-description text-heading/70 !leading-none shrink-0">
                            <i class="ri-bar-chart-2-line"></i>
                            <span class="text-heading dark:text-white mb-0.5">
                                <?php echo e(translate('Bundle Level')); ?>

                            </span>
                        </div>
                    </td>
                    <td class="px-1 py-4 text-right rtl:text-left">
                        <div class="text-heading dark:text-white font-semibold leading-none">
                            <?php $__currentLoopData = $bundle->levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $levelTranslations = parse_translation($level); ?>
                                <?php echo e($levelTranslations['name'] ?? ($level->name ?? '')); ?>

                                <?php if(!$loop->first): ?>
                                    ,
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="px-1 py-4 text-left rtl:text-right">
                        <div class="flex items-center gap-2 area-description text-heading/70 !leading-none shrink-0">
                            <i class="ri-book-line"></i>
                            <span class="text-heading dark:text-white mb-0.5">
                                <?php echo e(translate('Total Course')); ?>

                            </span>
                        </div>
                    </td>
                    <td class="px-1 py-4 text-right rtl:text-left">
                        <div class="text-heading dark:text-white font-semibold leading-none">
                            <?php echo e(count($bundle?->courses)); ?>

                        </div>
                    </td>
                </tr>
                <?php if($bundle?->is_certificate): ?>
                    <tr>
                        <td class="px-1 py-4 text-left rtl:text-right">
                            <div
                                class="flex items-center gap-2 area-description text-heading/70 !leading-none shrink-0">
                                <i class="ri-award-line"></i>
                                <span class="text-heading dark:text-white mb-0.5">
                                    <?php echo e(translate('Certificate')); ?>

                                </span>
                            </div>
                        </td>
                        <td class="px-1 py-4 text-right rtl:text-left">
                            <div class="text-heading dark:text-white font-semibold leading-none">
                                <?php echo e(translate('Yes')); ?>

                            </div>
                        </td>
                    </tr>
                <?php endif; ?>
                <tr>
                    <td class="px-1 py-4 text-left rtl:text-right">
                        <div class="flex items-center gap-2 area-description text-heading/70 !leading-none shrink-0">
                            <span class="text-heading dark:text-white text-lg font-bold mb-0.5">
                                <?php echo e(translate('Price')); ?>

                            </span>
                        </div>
                    </td>
                    <td class="px-1 py-4 text-right rtl:text-left">
                        <div
                            class="text-primary text-xl !leading-none font-bold text-right shrink-0 flex items-center justify-end gap-1.5">
                            <span><?php echo e($currencySymbol); ?><?php echo e(dotZeroRemove($bundle?->price ?? 0)); ?></span>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
        <?php if(!$hasPurchase): ?>
            <?php if(auth()->guard()->check()): ?>
                <button type="button" aria-label="Enroll the bundle"
                    class="btn b-solid btn-primary-solid btn-xl font-medium !rounded-full w-full h-12 add-to-cart"
                    data-course-id="<?php echo e($bundle->id); ?>" data-type="bundle">
                    <?php echo e(translate('Add To Cart')); ?>

                    <i class="ri-arrow-right-line rtl:before:content-['\ea60'] text-inherit"></i>
                </button>
            <?php endif; ?>
            <?php if(auth()->guard()->guest()): ?>
                <a href="<?php echo e(route('login')); ?>"
                    class="btn b-solid btn-primary-solid btn-xl h-12 !rounded-full w-full font-medium">
                    <?php echo e(translate('Add To Cart')); ?>

                    <i class="ri-arrow-right-line rtl:before:content-['\ea60'] text-inherit"></i>
                </a>
            <?php endif; ?>
        <?php else: ?>
            <button type="button" aria-label="Enroll the bundle"
                class="btn b-solid btn-primary-solid btn-xl font-medium !rounded-full w-full h-12 disabled"
                data-bundle-id="<?php echo e($bundle->id); ?>" data-type="bundle">
                <?php echo e(translate('purchased')); ?>


            </button>
        <?php endif; ?>
    </div>
</div>
<!-- START DEMO VIDEO MODAL -->
<?php if (isset($component)) { $__componentOriginal91f01d67f4c4b25e33bf354cf8541dc7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91f01d67f4c4b25e33bf354cf8541dc7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::bundle.details.demo-video','data' => ['bundle' => $bundle]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::bundle.details.demo-video'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['bundle' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($bundle)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91f01d67f4c4b25e33bf354cf8541dc7)): ?>
<?php $attributes = $__attributesOriginal91f01d67f4c4b25e33bf354cf8541dc7; ?>
<?php unset($__attributesOriginal91f01d67f4c4b25e33bf354cf8541dc7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91f01d67f4c4b25e33bf354cf8541dc7)): ?>
<?php $component = $__componentOriginal91f01d67f4c4b25e33bf354cf8541dc7; ?>
<?php unset($__componentOriginal91f01d67f4c4b25e33bf354cf8541dc7); ?>
<?php endif; ?>
<!-- END DEMO VIDEO MODAL -->
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\bundle\details\sidebar.blade.php ENDPATH**/ ?>