<?php
    $locale = request()->locale ?? app()->getLocale();
    $storeRoute = 'bundle.store';
    $updateRoute = 'bundle.update';
    $thumbnailRemove = 'bundle.thumbnail.delete';
    $translate = 'bundle.translate';
    if (isInstructor()) {
        $storeRoute = 'instructor.bundle.store';
        $updateRoute = 'instructor.bundle.update';
        $thumbnailRemove = 'instructor.bundle.thumbnail.delete';
        $translate = 'instructor.bundle.translate';
    } elseif (isOrganization()) {
        $storeRoute = 'organization.bundle.store';
        $updateRoute = 'organization.bundle.update';
        $thumbnailRemove = 'organization.bundle.thumbnail.delete';
        $translate = 'organization.bundle.translate';
    }

    $translations = [];
    $bundle = $bundle ?? null;
    if ($bundle && $locale) {
        $translations = parse_translation($bundle, $locale);
    }

    $backendSetting = get_theme_option(key: 'backend_general') ?? null;
    $platformFee = $backendSetting['platform_fee'] ?? 0;
    $bundlePrice = isset($bundle) ? $bundle->price - $bundle->platform_fee : null;

?>


<?php if(is_active($translate) === 'active'): ?>
    <div class="flex items-center justify-end gap-4 mb-2">
        <h2 class="card-title"><?php echo e(translate('Translate Language')); ?></h2>
        <form method="GET" class="sm:block" id="change-translate-language">
            <select onchange="window.location.href=this.options[this.selectedIndex].value" name="id"
                class="text-gray-500 dark:text-dark-text dark:bg-dark-card-shade font-semibold bg-white focus:outline-none cursor-pointer select-none text-sm border dk-border-one px-2 py-2 rounded-md dk-theme-card-square">
                <?php $__currentLoopData = app('languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($lang->code); ?>" <?php echo e(isset($locale) && $locale == $lang->code ? 'selected' : ''); ?>>
                        <?php echo e($lang->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </form>
    </div>
<?php endif; ?>
<form action="<?php echo e(isset($bundle) ? route($updateRoute, $bundle->id) : route($storeRoute)); ?>" class="mb-4 form"
    method="POST" enctype="multipart/form-data">
    <?php if(isset($bundle)): ?>
        <?php echo method_field('PUT'); ?>
        <input type="hidden" id="id" value="<?php echo e($bundle->id); ?>">
    <?php endif; ?>
    <input type="hidden" name="user_id" value="<?php echo e(authCheck()->id ?? ''); ?>">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="locale" class="form-input" value="<?php echo e($locale ?? ''); ?>">
    <div class="grid grid-cols-12 gap-x-4">
        <div class="col-span-full <?php echo e(is_active($translate) !== 'active' ? 'lg:col-span-6' : ''); ?> card">
            <h6 class="leading-none text-xl font-semibold text-heading"><?php echo e(translate('Bundle Info')); ?></h6>
            <div class="mt-7">
                <div class="mt-4">
                    <label for="bundle-title" class="form-label"> <?php echo e(translate('Title')); ?> <span class="text-danger"> *
                        </span> </label>
                    <input type="text" id="bundle-title" placeholder="<?php echo e(translate('Title')); ?>" class="form-input"
                        name="title" value="<?php echo e($translations['title'] ?? ($bundle->title ?? '')); ?>">
                    <span class="text-danger error-text title_err"></span>
                </div>
                <?php if(is_active($translate) == 'active'): ?>
                    <input type="hidden" id="bundle-price" name="price" class="form-input"
                        value="<?php echo e(isset($bundle) ? $bundle->price : ''); ?>">
                <?php endif; ?>
                <?php if(is_active($translate) !== 'active'): ?>
                    <div class="grid grid-cols-12 gap-4">
                        <div class="col-span-full lg:col-span-3">
                            <div class="mt-6">
                                <label for="currency" class="form-label"><?php echo e(translate('Currency')); ?>

                                    <span class="text-danger"
                                        title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                                </label>
                                <select data-select id="currency" name="currency" class="singleSelect">
                                    <option selected disabled data-display="<?php echo e(translate('Select Currency')); ?>">
                                        <?php echo e(translate('Select Currency')); ?> </option>
                                    <?php $__currentLoopData = all_currency(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $codeSymbol = $currency->code . '-' . $currency->symbol;
                                        ?>
                                        <option value="<?php echo e($currency->code . '-' . $currency->symbol); ?>"
                                            <?php echo e(isset($bundle) && $bundle?->currency == $codeSymbol ? 'selected' : ''); ?>>
                                            <?php echo e($currency->symbol); ?> - <?php echo e($currency->code); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <span class="text-danger error-text currency_err"></span>
                            </div>
                        </div>
                        <div class="col-span-full lg:col-span-4">
                            <div class="mt-6">
                                <label for="price" class="form-label"> <?php echo e(translate('Price')); ?> <span
                                        class="text-danger"
                                        title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                                </label>
                                <input type="number" placeholder="<?php echo e(translate('Your Price')); ?>"
                                    class="form-input bundle-price-cal" value="<?php echo e($bundlePrice ?? ''); ?>"
                                    id="price">

                            </div>
                        </div>
                        <div class="col-span-full lg:col-span-3">
                            <div class="mt-6">
                                <label for="platform_fee" class="form-label">
                                    <?php echo e(translate('Platform Price')); ?>

                                    <span class="text-danger"
                                        title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                                </label>

                                <input type="hidden"value="<?php echo e($platformFee ?? ''); ?>" name="platform_fee">
                                <input type="number" id="platform_fee" placeholder="<?php echo e(translate('Platform Fee')); ?>"
                                    disabled class="form-input disabled:!text-heading" value="<?php echo e($platformFee ?? ''); ?>"
                                    placeholder="Platform Price">
                                <span class="text-danger error-text title_err"></span>

                            </div>
                        </div>
                        <div class="col-span-full lg:col-span-2">
                            <div class="mt-6">
                                <label for="total_price" class="form-label"><?php echo e(translate('Total Price')); ?>

                                    <span class="text-danger"
                                        title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                                </label>
                                <input type="number" id="total_price" placeholder="<?php echo e(translate('Bundle Price')); ?>"
                                    name="price" class="form-input" value="<?php echo e($bundlePrice + $platformFee ?? ''); ?>">
                                <span class="text-danger error-text  price_err"></span>
                            </div>

                        </div>
                    </div>
                <?php endif; ?>
                <div class="mt-4">
                    <label for="coupon-type" class="form-label"><?php echo e(translate('Select courses')); ?> <span
                            class="text-danger"> *</span> </label>
                    <?php if(!isOrganization()): ?>
                        <select class="multipleSelect form-input" multiple="multiple" name="courseId[]">
                            <?php $__currentLoopData = get_course_by_instructorId(authCheck()->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $courseTranslationsData = parse_translation($course);
                                ?>
                                <option value="<?php echo e($course->id); ?>"
                                    <?php if(isset($bundle) && $bundle?->courses?->count() > 0): ?> <?php $__currentLoopData = $bundle?->courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bcourse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                   <?php echo e($bcourse->id == $course->id ? 'selected' : ''); ?>

                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>>
                                    <?php echo e($courseTranslationsData['title'] ?? $course->title); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    <?php else: ?>
                        <select class="multipleSelect form-input" multiple="multiple" name="courseId[]">
                            <?php $__currentLoopData = getOrganizationCourse(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $courseTranslations = parse_translation($course);
                                ?>
                                <option value="<?php echo e($course->id); ?>"
                                    <?php if(isset($bundle) && $bundle?->courses?->count() > 0): ?> <?php $__currentLoopData = $bundle?->courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bcourse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                       <?php echo e($bcourse->id == $course->id ? 'selected' : ''); ?>

                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>>
                                    <?php echo e($courseTranslations['title'] ?? $course->title); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    <?php endif; ?>
                    <span class="text-danger error-text courseId_err"></span>
                </div>
                <div class="mt-4">
                    <label class="form-label"><?php echo e(translate('Description')); ?></label>
                    <textarea name="details" class="form-input summernote"><?php echo clean($translations['details'] ?? ($bundle->details ?? '')); ?></textarea>
                </div>
            </div>
        </div>
        <?php if(is_active($translate) !== 'active'): ?>
            <div class="col-span-full lg:col-span-6 card">
                <h6 class="leading-none text-xl font-semibold text-heading"><?php echo e(translate('Media')); ?></h6>
                <div class="mt-7">
                    <p class="text-xs text-gray-500 dark:text-dark-text leading-none font-semibold mb-3">
                        <?php echo e(translate('Thumbnail')); ?>( 300 x 300 )
                    </p>
                    <label for="thumbnail-one"
                        class="dropzone-wrappe file-container ac-bg text-xs leading-none font-semibold mb-3 cursor-pointer w-full h-[200px] flex flex-col items-center justify-center gap-2.5 border border-dashed border-gray-900 rounded-10 dk-theme-card-square">
                        <input type="file" hidden name="image" id="thumbnail-one"
                            class="dropzone dropzone-image img-src peer/file">

                        <span class="flex-center flex-col peer-[.uploaded]/file:hidden">
                            <img src="<?php echo e(asset('lms/assets/images/icons/upload-file.svg')); ?>" alt="file-icon"
                                class="size-8 lg:size-auto">
                            <div class="text-gray-500 dark:text-dark-text mt-2"><?php echo e(translate('Choose file')); ?></div>
                        </span>
                    </label>
                    <div class="preview-zone dropzone-preview">
                        <div class="box box-solid">
                            <div class="box-body flex items-center gap-2 flex-wrap">

                                <?php if(isset($bundle) && fileExists('lms/courses/bundles', $bundle?->thumbnail) == true && $bundle?->thumbnail !== ''): ?>
                                    <div class="img-thumb-wrapper"> <button class="remove delete-btn-cs"
                                            data-action="<?php echo e(route($thumbnailRemove, $bundle->id)); ?>"
                                            data-title="<?php echo e(translate('Do you want to delete')); ?>"><i
                                                class="ri-close-line text-inherit text-[13px]"></i>
                                        </button>
                                        <img class="img-thumb" width="100"
                                            src="<?php echo e(asset('storage/lms/courses/bundles/' . $bundle->thumbnail)); ?>" />
                                    </div>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

    </div>
    <div class="card flex-center justify-end">
        <button type="submit" class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
            <?php echo e(isset($bundle) ? translate('Update') : translate('Save')); ?>

        </button>
    </div>
</form>
<?php $__env->startPush('js'); ?>
    <script>
        $('.multipleSelect').select2({
            placeholder: "<?php echo e(translate('Select Courses')); ?>",
            width: "100%"
        })
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\course\bundle\create-form.blade.php ENDPATH**/ ?>