<div class="col-span-full lg:col-span-6 2xl:col-span-4 card px-0 order-2 2xl:order-none">
    <div class="flex-center-between px-6 mb-7">
        <h6 class="card-title"> <?php echo e(translate('Trending categories')); ?> </h6>
    </div>
    <div class="max-h-[350px] smooth-scrollbar" data-scrollbar>
        <ul class="divide-y divide-gray-200 dark:divide-dark-border-three space-y-5 *:pt-5 px-6">
            <?php $__currentLoopData = $topCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $categoryTranslations = parse_translation($topCategory);
                ?>
                <li class="flex-center-between first:pt-0">
                    <div class="flex items-center gap-2.5">
                        <div
                            class="size-12 rounded-50 bg-primary-200 dark:bg-dark-icon flex-center flex-shrink-0 dk-theme-card-square">
                            <img src="<?php echo e(asset('lms/assets/images/icons/category/graphic-design.svg')); ?>" alt="icon">
                        </div>
                        <div>
                            <h6 class="leading-none text-heading dark:text-white font-semibold mb-2 line-clamp-1">
                                <a href="<?php echo e(route('course.index', "categories[]=$topCategory->id")); ?>"
                                    class="truncate"><?php echo e($categoryTranslations['title'] ?? $topCategory->title); ?></a>
                            </h6>
                            <p class="leading-none text-xs text-gray-500 dark:text-dark-text-two font-semibold">
                                <?php echo e($topCategory->courses_count); ?>+ <?php echo e(translate('Courses')); ?></p>
                        </div>
                    </div>
                    <a href="<?php echo e(route('course.index', "categories[]=$topCategory->id")); ?>"
                        class="flex-center size-6 rounded-md bg-primary-200 dark:bg-dark-icon shrink-0">
                        <i class="ri-arrow-right-line text-gray-500 dark:text-dark-text text-[14px]"></i>
                    </a>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </ul>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\admin\admin\trending-category.blade.php ENDPATH**/ ?>