<?php if(isset($paginator) && $paginator->hasPages()): ?>
    <!-- PAGINATION -->
    <div class="flex-center mt-10 lg:mt-[60px]">
        <ul class="flex items-center gap-x-2.5">
            <?php if(!$paginator->onFirstPage()): ?>
                <a class="slider-navigation disabled" href="<?php echo e($paginator->previousPageUrl()); ?>" aria-label="Pagination">
                    <i class="ri-arrow-left-line rtl:before:content-['\ea6c']"></i>
                </a>
            <?php endif; ?>
            <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(is_string($element)): ?>
                    <a class="slider-navigation disabled" aria-current="page"><?php echo e($element); ?></a>
                <?php endif; ?>
                <?php if(is_array($element)): ?>
                    <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($page == $paginator->currentPage()): ?>
                            <button type="button" aria-label="Pagination link" class="slider-navigation active"><?php echo e($page); ?></button>
                        <?php else: ?>
                            <a class="slider-navigation" aria-label="Pagination link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php if($paginator->hasMorePages()): ?>
                <a class="slider-navigation" href="<?php echo e($paginator->nextPageUrl()); ?>" aria-label="Pagination link">
                    <i class="ri-arrow-right-line rtl:before:content-['\ea60']"></i>
                </a>
            <?php else: ?>
                <button class="slider-navigation">
                    <i class="ri-arrow-right-line rtl:before:content-['\ea60']"></i>
                </button>
            <?php endif; ?>
        </ul>
    </div>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\theme\pagination\pagination-one.blade.php ENDPATH**/ ?>