<!-- Start Info -->
<div class="fieldset">
    <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="additional_information">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="course_id" class="courseId" value="<?php echo e($course->id ?? ''); ?>">
        <!-- COURSE FAQ -->
        <div class="card">
            <div class="grid grid-cols-12 gap-y-5 faq-item">
                <div class="col-span-full">
                    <div class="flex-center-between">
                        <h6 class="leading-none text-xl font-semibold text-heading"> <?php echo e(translate('Add Course FAQ')); ?>

                        </h6>
                        <button type="button" class="btn b-solid btn-primary-solid add-faq">
                            <i class="ri-add-circle-line text-inherit"></i> <?php echo e(translate('Add')); ?>

                        </button>
                    </div>
                </div>
                <div class="col-span-full">
                    <div class="flex flex-col gap-5 faq-area"
                        data-length="<?php echo e(isset($course, $course->courseFaqs) ? $course->courseFaqs->count() : 0); ?>">
                        <?php if(isset($course, $course->courseFaqs) && !empty($course->courseFaqs)): ?>
                            <?php $__currentLoopData = $course->courseFaqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseFaq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex gap-4">
                                    <div class="grow flex flex-col gap-2">
                                        <input type="hidden" name="faqs[<?php echo e($courseFaq->id); ?>][id]" class="form-input"
                                            value="<?php echo e($courseFaq->id); ?>">

                                        <input type="text"
                                            placeholder="<?php echo e(translate('Faq question')); ?>"name="faqs[<?php echo e($courseFaq->id); ?>][title]"
                                            class="form-input" value="<?php echo e($courseFaq->title); ?>">
                                        <textarea name="faqs[<?php echo e($courseFaq->id); ?>][answer]" placeholder="<?php echo e(translate('Faq Answer')); ?>" class="form-input"><?php echo e($courseFaq->answer); ?></textarea>
                                    </div>
                                    <button type="button" class="btn-icon btn-danger-icon-light shrink-0 delete-btn"
                                        data-id="<?php echo e($courseFaq->id); ?>" data-key="faq">
                                        <i class="ri-delete-bin-line text-inherit"></i>
                                    </button>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- COURSE OUTCOME -->
        <div class="card">
            <div class="grid grid-cols-12 gap-y-5 outcome-item">
                <div class="col-span-full">
                    <div class="flex-center-between">
                        <h6 class="leading-none text-xl font-semibold text-heading">
                            <?php echo e(translate('Add Course Outcomes')); ?> </h6>
                        <button type="button" class="btn b-solid btn-primary-solid add-outcomes"> <i
                                class="ri-add-circle-line text-inherit"></i> <?php echo e(translate('Add')); ?>

                        </button>
                    </div>
                </div>
                <div class="col-span-full">
                    <div class="flex flex-col gap-5 outcomes-area"
                        data-length="<?php echo e(isset($course, $course->courseOutComes) ? $course->courseOutComes->count() : 0); ?>">
                        <?php if(isset($course, $course->courseOutComes) && !empty($course->courseOutComes)): ?>
                            <?php $__currentLoopData = $course->courseOutComes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseOutCome): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex gap-4">
                                    <div class="grow flex flex-col gap-2 relative">
                                        <input type="text" placeholder="<?php echo e(translate('Course Outcomes')); ?>"
                                            id="searchInput" name="outcomes[<?php echo e($courseOutCome->id); ?>][title]"
                                            class="form-input outcomes search-suggestion"
                                            value="<?php echo e($courseOutCome->title); ?>" data-search-type="outcomes">

                                        <div class="search-show"></div>
                                    </div>
                                    <button type="button" class="btn-icon btn-danger-icon-light shrink-0 delete-btn">
                                        <i class="ri-delete-bin-line text-inherit"></i>
                                    </button>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- COURSE REQUIREMENTS -->
        <div class="card">
            <div class="grid grid-cols-12 gap-y-5 requirement-item">
                <div class="col-span-full">
                    <div class="flex-center-between">
                        <h6 class="leading-none text-xl font-semibold text-heading">
                            <?php echo e(translate('Course Requirements')); ?>

                        </h6>
                        <button type="button" class="btn b-solid btn-primary-solid add-requirement">
                            <i class="ri-add-circle-line text-inherit"></i> <?php echo e(translate('Add')); ?>

                        </button>
                    </div>
                </div>
                <div class="col-span-full">
                    <div class="flex flex-col gap-5 requirement-area"
                        data-length="<?php echo e(isset($course, $course->courseRequirements) ? $course->courseRequirements->count() : 0); ?>">
                        <?php if(isset($course, $course->courseRequirements) && !empty($course->courseRequirements)): ?>
                            <?php $__currentLoopData = $course->courseRequirements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseRequirement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex gap-4">
                                    <div class="grow flex flex-col gap-2 relative">
                                        <input type="text" placeholder="<?php echo e(translate('Course Requirements')); ?>"
                                            id="searchInput" name="requirements[<?php echo e($courseRequirement->id); ?>][title]"
                                            class="form-input search-suggestion" data-search-type="requirement"
                                            value="<?php echo e($courseRequirement->title); ?>">
                                        <div class="search-show"></div>
                                    </div>
                                    <button type="button" class="btn-icon btn-danger-icon-light shrink-0 delete-btn">
                                        <i class="ri-delete-bin-line text-inherit"></i>
                                    </button>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- COURSE TAG -->
        <div class="card">
            <div class="grid grid-cols-12 gap-4">
                <div class="col-span-full">
                    <div class="flex-center-between">
                        <h6 class="text-xl font-semibold text-heading"> <?php echo e(translate('Course Tag')); ?> </h6>
                    </div>
                </div>
                <div class="col-span-full">
                    <select class="tag-list" name="tags[]" multiple="multiple">
                        <option></option>
                    </select>
                </div>
            </div>
        </div>
        <div class="card flex-center gap-4 justify-end">
            <button type="button" class="prev-form-btn btn b-outline btn-primary-outline">
                <?php echo e(translate('Previous')); ?>

            </button>
            <button type="button" class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                <?php echo e(translate('Save & Continue')); ?>

            </button>
        </div>
    </form>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\course\additional-form.blade.php ENDPATH**/ ?>