<?php
    $subscribe = $data['subscribe'] ?? [];
?>
<form action="<?php echo e(route('newsletter.subscribe')); ?>" class="<?php echo e($subscribe['form_class'] ?? 'mt-6'); ?> form" method="POST">
    <?php echo csrf_field(); ?>
    <div class="<?php echo e($subscribe['wrapper_class'] ?? 'flex'); ?>">
        <input type="email" placeholder="<?php echo e(translate('Enter email address')); ?>" name="email" autocomplete="off"
            required
            class="<?php echo e($subscribe['input_class'] ?? 'bg-white text-heading/80 font-medium placeholder:text-heading/80 placeholder:font-semibold h-12 rounded-r-none rounded-l-full rtl:rounded-l-none rtl:rounded-r-full px-4 focus:outline-none grow'); ?> w-full">
        <button type="submit" aria-label="Join now with us"
            class="<?php echo e($subscribe['btn_class'] ?? 'btn b-solid btn-primary-solid rounded-l-none rounded-r-full rtl:rounded-r-none rtl:rounded-l-full'); ?>">
            <?php echo e($subscribe['btn_text'] ?? translate('Join Now')); ?>

        </button>
    </div>
</form>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\subscribe\subscribe-form.blade.php ENDPATH**/ ?>