<?php
    $user = $instructor?->userable ?? null;
    $profileImg = $user?->profile_img ?? '';
    $imgSrc =
        $profileImg && fileExists('lms/instructors', $profileImg) == true
            ? asset('storage/lms/instructors/' . $profileImg)
            : asset('lms/frontend/assets/images/370x396.svg');
    $userTranslations = parse_translation($user);
    if ($user?->designation) {
        $designationData = parse_translation($user?->designation);
    }
    if ($userTranslations) {
        $name = $userTranslations['first_name'] . ' ' . $userTranslations['last_name'];
    }

?>

<div class="swiper-slide col-span-full sm:col-span-6 xl:col-span-4">
    <div class="relative flex flex-col group/instructor">
        <div class="aspect-[1/1.26] overflow-hidden rounded-xl relative">
            <img data-src="<?php echo e($imgSrc); ?>" alt="Thumbnail image"
                class="size-full object-cover group-hover/instructor:scale-110 custom-transition">
            <?php if($instructor->socials->count() > 0): ?>
                <?php if (isset($component)) { $__componentOriginal895c5f52f52ad266a2c4117783433c56 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal895c5f52f52ad266a2c4117783433c56 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::social.social-list-one','data' => ['socials' => $instructor->socials,'hoverButton' => 'yes','ulClass' => '','itemClass' => 'flex-center size-10 rounded-50 bg-primary text-white hover:bg-secondary hover:text-heading dark:text-white custom-transition','listClass' => 'absolute top-3 right-2.5 z-0 group-hover/instructor:top-[calc(40px_*_1_+_12px)] duration-500']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::social.social-list-one'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['socials' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($instructor->socials),'hoverButton' => 'yes','ulClass' => '','itemClass' => 'flex-center size-10 rounded-50 bg-primary text-white hover:bg-secondary hover:text-heading dark:text-white custom-transition','listClass' => 'absolute top-3 right-2.5 z-0 group-hover/instructor:top-[calc(40px_*_1_+_12px)] duration-500']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal895c5f52f52ad266a2c4117783433c56)): ?>
<?php $attributes = $__attributesOriginal895c5f52f52ad266a2c4117783433c56; ?>
<?php unset($__attributesOriginal895c5f52f52ad266a2c4117783433c56); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal895c5f52f52ad266a2c4117783433c56)): ?>
<?php $component = $__componentOriginal895c5f52f52ad266a2c4117783433c56; ?>
<?php unset($__componentOriginal895c5f52f52ad266a2c4117783433c56); ?>
<?php endif; ?>
            <?php endif; ?>
        </div>
        <div class="flex justify-between mt-6">
            <div class="shrink-0 grow">
                <h6 class="area-title text-xl !leading-none font-bold group-hover/instructor:text-primary custom-transition">
                    <a href="<?php echo e(route('users.detail', $instructor->id)); ?>" class="flex items-center justify-between"
                        aria-label="Instructor full name">
                        <?php echo e($name ?? $user?->first_name . ' ' . $user?->last_name); ?>

                        <i class="ri-arrow-right-line text-[20px] rtl:before:content-['\ea60']"></i>
                        <span class="absolute inset-0" aria-hidden="true"></span>
                    </a>
                </h6>
                <p class="area-description !leading-none mt-1.5">
                    <?php echo e($designationData['title'] ?? ($user?->designation?->title ?? '')); ?>

                </p>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\cards\instructor-card-one.blade.php ENDPATH**/ ?>