<?php $courses = $courses ?? []; ?>

<div class="relative bg-white pt-16 sm:pt-24 lg:pt-[120px]">
    <div class="container">
        <!-- HEADER -->
        <div class="grid grid-cols-12 gap-4 items-center">
            <div class="col-span-full md:col-span-7 lg:pr-20">
                <div class="area-subtitle subtitle-outline style-three !text-secondary"><?php echo e(translate( 'New Courses' )); ?></div>
                <h2 class="area-title mt-2">
                    <?php echo e(translate( 'Our New Courses' )); ?>

                </h2>
            </div>
            <div class="col-span-full md:col-span-5 md:justify-self-end">
                <div class="flex items-center gap-2">
                    <button type="button" aria-label="Course slider button previous" class="slider-navigation style-two hover:!text-heading !rounded-md new-courses-prev">
                        <i class="ri-arrow-left-line rtl:before:content-['\ea6c']"></i>
                    </button>
                    <button type="button" aria-label="Course slider button next" class="slider-navigation style-two hover:!text-heading !rounded-md new-courses-next">
                        <i class="ri-arrow-right-line rtl:before:content-['\ea60']"></i>
                    </button>
                </div>
            </div>
        </div>
        <!-- BODY -->
        <?php if( !empty( $courses ) && is_iterable( $courses ) ): ?>
        <div class="swiper new-courses-slider mt-10 lg:mt-[60px]">
            <div class="swiper-wrapper">
                <!-- COURSE CARD -->
                <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="swiper-slide">
                    <?php if (isset($component)) { $__componentOriginale3f6f030cd740c73bb20a6dec162bcfa = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale3f6f030cd740c73bb20a6dec162bcfa = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::cards.course.card-four','data' => ['course' => $course,'cardBg' => 'bg-section']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::cards.course.card-four'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['course' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($course),'card-bg' => 'bg-section']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale3f6f030cd740c73bb20a6dec162bcfa)): ?>
<?php $attributes = $__attributesOriginale3f6f030cd740c73bb20a6dec162bcfa; ?>
<?php unset($__attributesOriginale3f6f030cd740c73bb20a6dec162bcfa); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale3f6f030cd740c73bb20a6dec162bcfa)): ?>
<?php $component = $__componentOriginale3f6f030cd740c73bb20a6dec162bcfa; ?>
<?php unset($__componentOriginale3f6f030cd740c73bb20a6dec162bcfa); ?>
<?php endif; ?>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php else: ?>
        <div class="bg-white border border-border rounded-xl h-[400px] shadow-md">
            <div class="flex-center flex-col gap-4 p-6 text-center max-w-screen-sm mx-auto h-full">
                <h2 class="area-title xl:text-3xl"><?php echo e(translate( 'Oops, Nothing Here Yet!' )); ?></h2>
                <p class="area-description">
                    <?php echo e(translate( "It looks like we don't have any courses in this category right now. Feel free to browse other categories or let us know if there's something specific you'd like to learn!" )); ?>

                </p>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\themes\digital-education\components\course\new-course.blade.php ENDPATH**/ ?>