<div class="fieldset">
    <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="additional_information">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="bundle_id" class="bundleId" value="<?php echo e($bundle->id ?? ''); ?>">
        <div class="card">
            <div class="grid grid-cols-12 gap-y-5 faq-item">
                <div class="col-span-full">
                    <div class="flex-center-between">
                        <h6 class="leading-none text-xl font-semibold text-heading">
                            <?php echo e(translate('Add Bundle FAQ')); ?>

                        </h6>
                        <button type="button" class="btn b-solid btn-primary-solid add-faq">
                            <i class="ri-add-circle-line text-inherit"></i> <?php echo e(translate('Add')); ?>

                        </button>
                    </div>
                </div>
                <div class="col-span-full">
                    <div class="flex flex-col gap-5 faq-area"
                        data-length="<?php echo e(isset($bundle, $bundle->bundleFaqs) ? $bundle->bundleFaqs->count() : 0); ?>">
                        <?php if(isset($bundle, $bundle->bundleFaqs) && !empty($bundle->bundleFaqs)): ?>
                            <?php $__currentLoopData = $bundle->bundleFaqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bundleFaq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex gap-4">
                                    <div class="grow flex flex-col gap-2">
                                        <input type="hidden" name="faqs[<?php echo e($bundleFaq->id); ?>][id]" class="form-input"
                                            value="<?php echo e($bundleFaq->id); ?>">

                                        <input type="text"
                                            placeholder="<?php echo e(translate('Faq question')); ?>"name="faqs[<?php echo e($bundleFaq->id); ?>][title]"
                                            class="form-input" value="<?php echo e($bundleFaq->question); ?>">
                                        <textarea name="faqs[<?php echo e($bundleFaq->id); ?>][answer]" placeholder="<?php echo e(translate('Faq Answer')); ?>" class="form-input"><?php echo e($bundleFaq->answer); ?></textarea>
                                    </div>
                                    <button type="button" class="btn-icon btn-danger-icon-light shrink-0 delete-btn"
                                        data-id="<?php echo e($bundleFaq->id); ?>" data-key="faq">
                                        <i class="ri-delete-bin-line text-inherit"></i>
                                    </button>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- COURSE OUTCOME -->
        <div class="card">
            <div class="grid grid-cols-12 gap-y-5 outcome-item">
                <div class="col-span-full">
                    <div class="flex-center-between">
                        <h6 class="leading-none text-xl font-semibold text-heading">
                            <?php echo e(translate('Add Bundle Outcomes')); ?> </h6>
                        <button type="button" class="btn b-solid btn-primary-solid add-outcomes"> <i
                                class="ri-add-circle-line text-inherit"></i> <?php echo e(translate('Add')); ?>

                        </button>
                    </div>
                </div>
                <div class="col-span-full">
                    <div class="flex flex-col gap-5 outcomes-area"
                        data-length="<?php echo e(isset($bundle, $bundle->bundleOutComes) ? $bundle->bundleOutComes->count() : 0); ?>">
                        <?php if(isset($bundle, $bundle->bundleOutComes) && !empty($bundle->bundleOutComes)): ?>
                            <?php $__currentLoopData = $bundle->bundleOutComes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bundleOutCome): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex gap-4">
                                    <div class="grow flex flex-col gap-2 relative">
                                        <input type="text" placeholder="<?php echo e(translate('Bundle Outcomes')); ?>"
                                            id="searchInput" name="outcomes[<?php echo e($bundleOutCome->id); ?>][title]"
                                            class="form-input outcomes search-suggestion"
                                            value="<?php echo e($bundleOutCome->title); ?>" data-search-type="outcomes">

                                        <div class="search-show"></div>
                                    </div>
                                    <button type="button" class="btn-icon btn-danger-icon-light shrink-0 delete-btn">
                                        <i class="ri-delete-bin-line text-inherit"></i>
                                    </button>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="card flex-center gap-4 justify-end">
            <button type="button" class="prev-form-btn btn b-outline btn-primary-outline">
                <?php echo e(translate('Previous')); ?>

            </button>
            <button type="button" class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                <?php echo e(translate('Save & Continue')); ?>

            </button>
        </div>
    </form>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\course\bundle\additional-form.blade.php ENDPATH**/ ?>