<table class="table-auto w-full whitespace-nowrap text-left rtl:text-right">
    <thead class="border-b border-border">
        <tr>
            <th class="px-3.5 py-4"> <?php echo e(translate('Course')); ?> </th>
            <th class="px-3.5 py-4 w-20"> <?php echo e(translate('Price')); ?> </th>
            <th class="px-3.5 py-4 w-10"><?php echo e(translate('Action')); ?></th>
        </tr>
    </thead>
    <tbody class="divide-y divide-border">

        <?php $__currentLoopData = $cartCourses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cartCourse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $route =
                    $cartCourse['type'] == 'course'
                        ? route('course.detail', $cartCourse['slug'])
                        : route('bundle.detail', $cartCourse['slug']);

                $currencySymbol = get_currency_symbol($cartCourse['currency']);
            ?>
            <tr>
                <td class="px-3.5 py-4">
                    <div class="flex items-center gap-2">
                        <a href="<?php echo e($route); ?>" class="size-20 rounded-50 overflow-hidden"
                            aria-label="Course information">
                            <?php if(
                                $cartCourse['type'] == 'course' &&
                                    fileExists('lms/courses/thumbnails', $cartCourse['image']) == true &&
                                    $cartCourse['image'] != ''): ?>
                                <img data-src="<?php echo e(asset('storage/lms/courses/thumbnails/' . $cartCourse['image'])); ?>"
                                    alt="Course thumbnail" class="size-full object-cover">
                            <?php elseif(
                                $cartCourse['type'] == 'bundle' &&
                                    fileExists('lms/courses/bundles', $cartCourse['image']) == true &&
                                    $cartCourse['image'] != ''): ?>
                                <img data-src="<?php echo e(asset('storage/lms/courses/bundles/' . $cartCourse['image'])); ?>"
                                    alt="Course thumbnail" class="size-full object-cover">
                            <?php else: ?>
                                <img data-src="<?php echo e(asset('lms/frontend/assets/images/420x252.svg')); ?>"
                                    alt="Course thumbnail" class="size-full object-cover">
                            <?php endif; ?>
                        </a>
                        <div>
                            <h6
                                class="text-lg leading-none text-heading dark:text-white font-semibold hover:underline custom-transition mb-1.5 line-clamp-1">
                                <a href="<?php echo e($route); ?>" aria-label="Course title">
                                    <?php if($cartCourse['type'] == 'course'): ?>
                                        <?php echo e(str_limit($courseTranslations['title'] ?? $cartCourse['title'], 30)); ?>

                                    <?php else: ?>
                                        <?php echo e(str_limit($cartCourse['title'], 30)); ?>

                                    <?php endif; ?>

                                </a>
                            </h6>
                            <div class="flex items-center gap-2">
                                <div class="flex items-center gap-1">
                                    <i class="ri-star-fill text-sm !text-secondary"></i>
                                    <span
                                        class="text-xs font-semibold leading-none"><?php echo e($cartCourse['review']['average_rating'] ?? 0); ?></span>
                                </div>
                                <p class="font-normal text-xs text-heading/70"><?php echo e(translate('Author')); ?> -
                                    <?php echo e($cartCourse['author']); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </td>
                <td class="px-3.5 py-4">
                    <span class="text-primary font-semibold">
                        <?php if(isset($cartCourse['discount_price']) && $cartCourse['discount_price'] !== 0): ?>
                            <?php echo e($currencySymbol); ?><?php echo e($cartCourse['currency']); ?>

                            <del>
                                <?php echo e($currencySymbol); ?><?php echo e($cartCourse['price']); ?></del>
                        <?php else: ?>
                            <?php echo e($currencySymbol); ?><?php echo e($cartCourse['price']); ?>

                        <?php endif; ?>
                    </span>
                </td>
                <td class="px-3.5 py-4">
                    <button type="button" class="btn text-danger font-bold remove-cart"
                        data-id="<?php echo e($cartCourse['id']); ?>" aria-label="Remove course from list"
                        data-action="<?php echo e(route('remove.cart')); ?>">
                        <?php echo e(translate('Remove')); ?>

                    </button>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\carts\cart-list.blade.php ENDPATH**/ ?>