<?php
    $locale = request()->locale ?? app()->getLocale();
    $isOrganization = isOrganization();
    $isAdmin = isAdmin();
    $isInstructor = isInstructor();
    $currentUser = authCheck();
    $type = $type ?? '';

    $translations = [];
    $bundle = $bundle ?? null;
    if ($bundle && $locale) {
        $translations = parse_translation($bundle, $locale);
    }
?>
<div class="fieldset !block">
    <form action="<?php echo e($action ?? '#'); ?>" class="mb-4 form" method="POST" data-key="basic">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="locale" class="form-input" value="<?php echo e($locale ?? ''); ?>">
        <input type="hidden" name="bundle_id" class="form-input" value="<?php echo e($bundle->id ?? ''); ?>">
        <?php if($isInstructor): ?>
            <input type="hidden" name="instructor_id" class="form-input" value="<?php echo e($currentUser->id ?? ''); ?>">
        <?php endif; ?>
        <div class="grid grid-cols-12 gap-x-4">
            <div class="col-span-full lg:col-span-6 card">
                <div class="mt-7">
                    <div class="mt-6">
                        <label for="bundle-title" class="form-label"> <?php echo e(translate('Title')); ?>

                            <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                        </label>
                        <input type="text" id="bundle-title" placeholder="<?php echo e(translate('Title')); ?>"
                            class="form-input" name="title"
                            value="<?php echo e($translations['title'] ?? ($bundle->title ?? '')); ?>">
                        <span class="text-danger error-text title_err"></span>
                    </div>
                </div>

                <div class="leading-none mt-6">
                    <label for="courseCategory" class="form-label">
                        <?php echo e(translate('Category')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <select name="category_id" id="courseCategory"
                        class="list-border-primary px-5 py-[17.5px] wide leading-none border border-input-border rounded-10 text-gray-900 font-spline_sans [&.open]:border-primary-400">
                        <option></option>
                        <?php $__currentLoopData = get_all_category(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $categoryTranslations = parse_translation($category, $locale);
                            ?>
                            <option value="<?php echo e($category->id); ?>"
                                <?php echo e(isset($bundle) && $bundle->category_id == $category->id ? 'selected' : ''); ?>>
                                <?php echo e($categoryTranslations['title'] ?? ($category->title ?? '')); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <span class="text-danger error-text category_id_err"></span>
                </div>
            </div>

            <div class="col-span-full lg:col-span-6 card">
                <div class="leading-none mt-6">
                    <label for="bundleLevel" class="form-label">
                        <?php echo e(translate('Bundle level')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <select name="levels[]" multiple="true" id="bundleLevel"
                        class="level-list list-border-primary px-5 py-[17.5px] wide leading-none border border-input-border rounded-10 text-gray-900 font-spline_sans [&.open]:border-primary-400">
                        <?php $__currentLoopData = get_all_level(locale: $locale); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $levelTranslations = parse_translation($level, $locale);
                            ?>
                            <option value="<?php echo e($level->id); ?>"
                                <?php if(isset($bundle, $bundle->levels) && !empty($bundle->levels)): ?> <?php $__currentLoopData = $bundle->levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bLevel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e($bLevel->id == $level->id ? 'selected' : ''); ?>

                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>>
                                <?php echo e($levelTranslations['name'] ?? ($level->name ?? '')); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>

                    <span class="text-danger error-text levels_err"></span>
                </div>

                <?php if($isAdmin || $isOrganization): ?>
                    <div class="leading-none mt-6">
                        <label class="form-label">
                            <?php echo e(translate('Instructor')); ?>

                            <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                        </label>
                        <select class="js-example-basic-single" name="instructor_id" id="instructorOption">
                            <option disabled><?php echo e(translate('Select Instructor')); ?></option>
                            <?php $__currentLoopData = get_all_instructor($currentUser->id ?? null, locale: $locale); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $insUser = $instructor?->userable;
                                    $userTranslations = parse_translation($insUser, $locale);
                                ?>
                                <option value="<?php echo e($instructor->id); ?>"
                                    <?php echo e(isset($bundle) && $bundle->user_id == $instructor->id ? 'selected' : ''); ?>>
                                    <?php echo e($userTranslations['first_name'] ?? $insUser?->first_name); ?>

                                    <?php echo e($userTranslations['last_name'] ?? $insUser?->last_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <span class="text-danger error-text instructors_err"></span>
                    </div>
                <?php endif; ?>
            </div>

            <div class="card col-span-full">
                <label class="form-label"><?php echo e(translate('Description')); ?> <span class="text-danger"
                        title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span></label>
                <textarea name="details" class="form-input summernote">
                    <?php echo clean($translations['details'] ?? ($bundle->details ?? '')); ?>

                </textarea>
                <span class="text-danger error-text details_err"></span>
            </div>
        </div>

        <div class="card flex-center gap-4 justify-end">
            <button type="button" class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">

                <?php if($type == 'translations'): ?>
                    <?php echo e(translate('Save')); ?>

                <?php else: ?>
                    <?php echo e(!isset($bundle) ? translate('Save') : translate('Save & Continue')); ?>

                <?php endif; ?>
            </button>
        </div>
    </form>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\course\bundle\basic-form.blade.php ENDPATH**/ ?>