<div id="theme-preview-modal<?php echo e($theme['id'] ?? null); ?>"
    class="fixed inset-0 z-modal flex-center !hidden bg-black bg-opacity-50 modal">
    <div
        class="modal-content bg-white dark:bg-dark-card-two rounded-lg shadow-lg w-full max-w-screen-lg transform transition-all duration-300 opacity-0 -translate-y-10 m-4">

        <!-- Modal Header -->
        <div class="flex items-center justify-between p-4 border-b border-gray-200 dark:border-dark-border">
            <h2 class="text-xl font-semibold"><?php echo e(translate('Theme Preview')); ?></h2>
            <button type="button"
                class="absolute top-3 end-2.5 text-gray-500 dark:text-dark-text hover:bg-gray-200 dark:hover:bg-dark-icon rounded-lg size-8 flex-center close-modal-btn">
                <i class="ri-close-line text-inherit"></i>
            </button>
        </div>
        <!-- Modal Body -->
        <div class="p-4 max-h-[80vh] overflow-auto">
            <div class="flex flex-col-reverse lg:flex-row gap-6">
                <div class="grow flex flex-col">
                    <h2 class="text-heading dark:text-white text-2xl"><?php echo e($theme['name'] ?? ''); ?></h2>
                    <div class="text-gray-500 dark:text-dark-text text-sm"> <?php echo e(translate('by')); ?>

                        <strong><?php echo e($theme['author'] ?? null); ?></strong>
                    </div>
                    <p class="card-description mt-5">
                        <?php echo e($theme['description']); ?>

                    </p>

                    <div class="mt-auto flex items-center justify-end">

                        <?php if($theme['is_installed'] && !$theme['is_activated']): ?>
                            <form method="post" action="<?php echo e(route('theme.activate')); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="name" value="<?php echo e($theme['name'] ?? $theme['slug']); ?>" />
                                <input type="hidden" name="slug" value="<?php echo e($theme['slug']); ?>" />
                                <input type="hidden" name="id" value="<?php echo e($theme['id']); ?>" />
                                <div class="mt-auto flex items-center justify-end">
                                    <button class="btn b-solid btn-primary-solid btn-sm">
                                        <?php echo e(translate('Activate')); ?></button>
                                </div>
                            </form>
                        <?php elseif($theme['is_activated']): ?>
                            <button type="button" class="btn b-solid btn-primary-solid btn-sm" disabled>
                                <?php echo e(translate('Activated')); ?>

                            </button>
                        <?php else: ?>
                            <form method="post" action="<?php echo e(route('theme.install')); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="name" value="<?php echo e($theme['name'] ?? $theme['slug']); ?>" />
                                <input type="hidden" name="slug" value="<?php echo e($theme['slug']); ?>" />
                                <button type="submit" class="btn b-solid btn-primary-solid btn-sm">
                                    <?php echo e(translate('Install')); ?> </button>
                            </form>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="relative theme-preview shrink-0 w-full lg:w-[60%] max-w-[1200px]">
                    <img src="<?php echo e(theme_asset($theme['slug'] . '/thumbnail.png')); ?>" alt="theme" class="">
                    <span class="absolute top-4 left-4">
                        <span
                            class="badge b-solid badge-primary-solid !bg-heading"><?php echo e($theme['version'] ?? ''); ?></span>
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\theme\preview.blade.php ENDPATH**/ ?>