<?php
    $bundles = $bundles ?? [];
    $totalBundle = count($bundles);

    $bundleRoute = '';
    $bundleBtnText = '';

    if ($totalBundle > 0) {
        $bundleRoute = '';
        $bundleBtnText = 'View all bundle';
    }

    if (isAdmin() && $totalBundle < 1) {
        $bundleRoute = 'bundle.create';
        $bundleBtnText = 'Add Bundle';
    }
?>

<div class="bg-section pb-16 sm:pb-24 lg:pb-[120px]">
    <div class="container">
        <!-- HEADER -->
        <div class="grid grid-cols-12 gap-4 items-center">
            <div class="col-span-full text-center max-w-[594px] mx-auto">
                <div class="area-subtitle">
                    <?php echo e(translate('Latest Bundle')); ?>

                </div>
                <h2 class="area-title mt-2">
                    <?php echo e(translate('See Our Popular')); ?>

                    <span class="title-highlight-one">
                        <?php echo e(translate('Bundle')); ?>

                    </span>
                    <?php echo e(translate('Courses')); ?>

                </h2>
            </div>
        </div>
        <!-- BODY -->
        <div class="swiper up-coming-courses-slider mt-10 lg:mt-[60px]">
            <div class="swiper-wrapper">
                <?php $__currentLoopData = $bundles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bundle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="swiper-slide col-span-full group-data-[card-layout=list]:!col-span-full">
                        <?php if (isset($component)) { $__componentOriginal37bc5e9bfeaa75e0598497d91c20f837 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal37bc5e9bfeaa75e0598497d91c20f837 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::cards.bundle.card-one','data' => ['bundle' => $bundle]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::cards.bundle.card-one'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['bundle' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($bundle)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal37bc5e9bfeaa75e0598497d91c20f837)): ?>
<?php $attributes = $__attributesOriginal37bc5e9bfeaa75e0598497d91c20f837; ?>
<?php unset($__attributesOriginal37bc5e9bfeaa75e0598497d91c20f837); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal37bc5e9bfeaa75e0598497d91c20f837)): ?>
<?php $component = $__componentOriginal37bc5e9bfeaa75e0598497d91c20f837; ?>
<?php unset($__componentOriginal37bc5e9bfeaa75e0598497d91c20f837); ?>
<?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php if($bundleRoute && $bundleRoute): ?>
            <div class="flex-center mt-10 lg:mt-[60px]">
                <a
                    href="<?php echo e(route($bundleRoute)); ?>"
                    title="<?php echo e($bundleRoute); ?>"
                    class="btn b-solid btn-primary-solid btn-xl !rounded-full font-medium text-[16px] md:text-[18px]"
                    aria-label="<?php echo e($bundleRoute); ?>"
                >
                    <?php echo e(translate($bundleBtnText)); ?>

                    <span class="hidden md:block">
                        <i class="ri-arrow-right-up-line text-[20px] rtl:before:content-['\ea66']"></i>
                    </span>
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\bundle\latest-bundle.blade.php ENDPATH**/ ?>