<?php
    $locale = request()->locale ?? app()->getLocale();
    $translations = [];
    $bundle = $bundle ?? null;
    if ($bundle && $locale) {
        $translations = parse_translation($bundle, $locale);
    }
    $backendSetting = get_theme_option(key: 'backend_general') ?? null;
    $platformFee = $backendSetting['platform_fee'] ?? 0;
    $bundlePrice = isset($bundle) ? $bundle->price - $bundle->platform_fee : null;
    $isOrganization = isOrganization();
    $isAdmin = isAdmin();
?>
<?php if (isset($component)) { $__componentOriginald7f77a02f879fd4954ea3c39c4e952cb = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb = $attributes; } ?>
<?php $component = Modules\LMS\View\Components\Dashboard\Layout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Modules\LMS\View\Components\Dashboard\Layout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> <?php echo e(isset($language) ? translate('Edit') : translate('Create')); ?>

        <?php echo e(translate('Bundle')); ?> <?php $__env->endSlot(); ?>
    <!-- BREADCRUMB -->
    <?php if (isset($component)) { $__componentOriginalcf27f2c2c873893339708d5fdeeb6984 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalcf27f2c2c873893339708d5fdeeb6984 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.breadcrumb','data' => ['backUrl' => ''.e(route('bundle.index')).'','title' => ''.e(isset($language) ? 'Edit' : 'Create').' Bundle','pageTo' => 'Bundle']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['back-url' => ''.e(route('bundle.index')).'','title' => ''.e(isset($language) ? 'Edit' : 'Create').' Bundle','page-to' => 'Bundle']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalcf27f2c2c873893339708d5fdeeb6984)): ?>
<?php $attributes = $__attributesOriginalcf27f2c2c873893339708d5fdeeb6984; ?>
<?php unset($__attributesOriginalcf27f2c2c873893339708d5fdeeb6984); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcf27f2c2c873893339708d5fdeeb6984)): ?>
<?php $component = $__componentOriginalcf27f2c2c873893339708d5fdeeb6984; ?>
<?php unset($__componentOriginalcf27f2c2c873893339708d5fdeeb6984); ?>
<?php endif; ?>
    <div class="card">
        <div class="container relative">
            <button
                class="prev-step-btn btn-icon b-solid btn-primary-icon-solid opacity-40 hover:opacity-100 absolute top-1/2 -left-4 -translate-y-1/2">
                <i class="ri-arrow-left-circle-line text-inherit text-[24px]"></i>
            </button>
            <div
                class="stepper-menu flex items-center text-center overflow-hidden scroll-smooth [&.dragging]:scroll-auto [&.dragging]:cursor-grab group/stepper-menu">
                <button type="button" class="stepper-step-btn">
                    <i class="ri-stack-line text-inherit"></i>
                    <?php echo e(translate('Basic')); ?>

                </button>
                <button type="button" class="stepper-step-btn active">
                    <i class="ri-image-2-line text-inherit"></i>
                    <?php echo e(translate('Media')); ?>

                </button>
                <button type="button" class="stepper-step-btn">
                    <i class="ri-price-tag-2-line text-inherit"></i>
                    <?php echo e(translate('Price')); ?>

                </button>
                <button type="button" class="stepper-step-btn">
                    <i class="ri-information-line text-inherit"></i>
                    <?php echo e(translate('Course')); ?>

                </button>
                <button type="button" class="stepper-step-btn active">
                    <i class="ri-settings-3-line text-inherit"></i>
                    <?php echo e(translate('Extra Information')); ?>

                </button>

                <button type="button" class="stepper-step-btn active">
                    <i class="ri-settings-3-line text-inherit"></i>
                    <?php echo e(translate('Setting')); ?>

                </button>
                <button type="button" class="stepper-step-btn">
                    <i class="ri-flag-line text-inherit"></i>
                    <?php echo e(translate('Finish')); ?>

                </button>
            </div>
            <button
                class="next-step-btn btn-icon b-solid btn-primary-icon-solid opacity-40 hover:opacity-100 absolute top-1/2 -right-4 -translate-y-1/2">
                <i class="ri-arrow-right-circle-line text-inherit text-[24px]"></i>
            </button>
        </div>
    </div>
    <div class="mb-4">
        <div id="msform" class="*:hidden">
            <div class="fieldset">
                <form action="<?php echo e(isset($bundle) ? route('bundle.update', $bundle->id) : route('bundle.store')); ?>"
                    class="mb-4 form" method="POST" enctype="multipart/form-data">
                    <?php if(isset($bundle)): ?>
                        <?php echo method_field('PUT'); ?>
                        <input type="hidden" id="id" value="<?php echo e($bundle->id); ?>">
                    <?php endif; ?>
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="locale" class="form-input" value="<?php echo e($locale ?? ''); ?>">
                    <div class="grid grid-cols-12 gap-x-4">
                        <div
                            class="col-span-full <?php echo e(is_active('bundle.translate') !== 'active' ? 'lg:col-span-6' : ''); ?> card">
                            <div class="mt-7">
                                <div class="mt-6">
                                    <label for="bundle-title" class="form-label"> <?php echo e(translate('Title')); ?>

                                        <span class="text-danger"
                                            title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                                    </label>
                                    <input type="text" id="bundle-title" placeholder="<?php echo e(translate('Title')); ?>"
                                        class="form-input" name="title"
                                        value="<?php echo e($translations['title'] ?? ($bundle->title ?? '')); ?>">
                                    <span class="text-danger error-text title_err"></span>
                                </div>
                            </div>
                            <div class="leading-none mt-6">
                                <label for="courseCategory" class="form-label">
                                    <?php echo e(translate('Courses category')); ?>

                                    <span class="text-danger"
                                        title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                                </label>
                                <select name="category_id" id="courseCategory"
                                    class="list-border-primary px-5 py-[17.5px] wide leading-none border border-input-border rounded-10 text-gray-900 font-spline_sans [&.open]:border-primary-400">
                                    <option></option>
                                    <?php $__currentLoopData = get_all_category(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $categoryTranslations = parse_translation($category, $locale); ?>
                                        <option value="<?php echo e($category->id); ?>"
                                            <?php echo e(isset($course) && $course->category_id == $category->id ? 'selected' : ''); ?>>
                                            <?php echo e($categoryTranslations['title'] ?? ($category->title ?? '')); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <span class="text-danger error-text category_id_err"></span>
                            </div>
                        </div>
                        <?php if(is_active('bundle.translate') !== 'active'): ?>
                            <div class="col-span-full lg:col-span-6 card">
                                <div class="leading-none mt-6">
                                    <label for="courseLevel" class="form-label">
                                        <?php echo e(translate('Courses level')); ?>

                                        <span class="text-danger"
                                            title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                                    </label>
                                    <select name="levels[]" multiple="true" id="courseLevel"
                                        class="level-list list-border-primary px-5 py-[17.5px] wide leading-none border border-input-border rounded-10 text-gray-900 font-spline_sans [&.open]:border-primary-400">
                                        <?php $__currentLoopData = get_all_level(locale: $locale); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php $levelTranslations = parse_translation($level, $locale); ?>
                                            <option value="<?php echo e($level->id); ?>"
                                                <?php if(isset($course, $course->levels) && !empty($course->levels)): ?> <?php $__currentLoopData = $course->levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clevel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php echo e($clevel->id == $level->id ? 'selected' : ''); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>>
                                                <?php echo e($levelTranslations['name'] ?? ($level->name ?? '')); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <span class="text-danger error-text levels_err"></span>
                                </div>

                                <?php if(!$isOrganization): ?>
                                    <div class="leading-none mt-6">
                                        <label for="courseInstructor" class="form-label">
                                            <?php echo e(translate('Organization')); ?> </label>
                                        <select
                                            class="js-example-basic-single form-input px-5 py-4 rounded-10  <?php echo e($isAdmin || $isOrganization ? 'organization-list' : ''); ?> "
                                            name="organization_id" data-locale="<?php echo e($locale); ?>">
                                            <option value="no-select"> <?php echo e(translate('Select Organization')); ?> </option>
                                            <?php $__currentLoopData = get_all_organization(locale: $locale); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organization): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $orgUser = $organization?->userable;
                                                    $orgTranslations = parse_translation($orgUser, $locale);
                                                ?>
                                                <option value="<?php echo e($organization->id); ?>"
                                                    <?php echo e(isset($course) && $course->organization_id == $organization->id ? 'selected' : ''); ?>>
                                                    <?php echo e($orgTranslations['name'] ?? $orgUser?->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                <?php endif; ?>

                                <?php if($isAdmin || $isOrganization): ?>
                                    <div class="leading-none mt-6">
                                        <label class="form-label">
                                            <?php echo e(translate('Instructor')); ?>

                                            <span class="text-danger"
                                                title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                                        </label>
                                        <select class="js-example-basic-single" name="instructors[]"
                                            id="instructorOption" multiple>
                                            <option disabled><?php echo e(translate('Select Instructor')); ?></option>

                                            <?php $__currentLoopData = get_all_instructor($currentUser->id ?? null, locale: $locale); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $insUser = $instructor?->userable;
                                                    $userTranslations = parse_translation($insUser, $locale);
                                                ?>
                                                <option value="<?php echo e($instructor->id); ?>"
                                                    <?php if(isset($course, $course->instructors) && !empty($course->instructors)): ?> <?php $__currentLoopData = $course->instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cinstructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                         <?php echo e($cinstructor->id == $instructor->id ? 'selected' : ''); ?>

                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>>
                                                    <?php echo e($userTranslations['first_name'] ?? $insUser?->first_name); ?>

                                                    <?php echo e($userTranslations['last_name'] ?? $insUser?->last_name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <span class="text-danger error-text instructors_err"></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <div class="card col-span-full">
                            <label class="form-label"><?php echo e(translate('Description')); ?></label>
                            <textarea name="details" class="form-input summernote"><?php echo clean($translations['details'] ?? ($bundle->details ?? '')); ?></textarea>
                        </div>
                    </div>
                    <div class="card flex-center justify-end">
                        <button type="submit"
                            class="btn b-solid btn-primary-solid dk-theme-card-square"><?php echo e(translate('Submit')); ?></button>
                    </div>
                </form>
            </div>
            <div class="fieldset">
                <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="media">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="course_id" class="courseId" value="<?php echo e($course->id ?? ''); ?>">
                    <div class="grid grid-cols-12 gap-x-4">
                        <div class="col-span-full lg:col-span-7 card">
                            <?php
                                $src_type = $course->video_src_type ?? null;
                            ?>
                            <div class="leading-none mt-6">
                                <label class="form-label">
                                    <?php echo e(translate('Bundle Demo Video')); ?>

                                    <span class="text-danger"
                                        title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                                </label>
                                <select class="singleSelect" name="video_src_type" id="source-type-select">
                                    <option disabled selected><?php echo e(translate('Select Source Type')); ?></option>
                                    <option value="youtube" <?php echo e($src_type == 'youtube' ? 'selected' : ''); ?>>
                                        <?php echo e(translate('Youtube')); ?></option>
                                    <option value="vimeo" <?php echo e($src_type == 'vimeo' ? 'selected' : ''); ?>>
                                        <?php echo e(translate('Vimeo')); ?>

                                    </option>
                                    <option value="local" <?php echo e($src_type == 'local' ? 'selected' : ''); ?>>
                                        <?php echo e(translate('Local')); ?>

                                    </option>
                                </select>
                                <span class="text-danger error-text video_src_type_err"></span>
                                <div id="courseVideoFile" class="mt-4">
                                    <?php if(isset($course, $src_type) && $src_type !== 'local'): ?>
                                        <label class="form-label">
                                            <?php echo e(translate('Video url')); ?>

                                            <span class="text-danger"
                                                title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                                        </label>
                                        <input type="url" class="form-input"
                                            placeholder="<?php echo e(translate('Video url')); ?>"
                                            value="<?php echo e($course->demo_url ?? ''); ?>" name="demo_url"
                                            autocomplete="off" />
                                    <?php elseif(isset($course) && $src_type == 'local'): ?>
                                        <label class="form-label">
                                            <?php echo e(translate('Upload File')); ?>

                                            <span class="text-danger"
                                                title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                                        </label>
                                        <div class="border border-input-border rounded-md px-2 py-1.5">
                                            <input type="file" class="w-full" name="short_video">
                                        </div>
                                        <span class="text-danger error-text short_video_err"></span>
                                        <?php if(isset($course)): ?>
                                            <div class="video mt-4">
                                                <?php if(fileExists($folder = 'lms/courses/demo-videos', $fileName = $course->short_video) == true &&
                                                        $course->short_video !== ''): ?>
                                                    <video width="320" height="240" controls autoplay>
                                                        <source
                                                            src="<?php echo e(asset('storage/lms/courses/demo-videos/' . $course->short_video)); ?>">
                                                    </video>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-span-full lg:col-span-5 card">
                            <p class="text-xs text-gray-500 dark:text-dark-text leading-none font-semibold mb-3">
                                <?php echo e(translate('Thumbnail')); ?>(<?php echo e(translate('300')); ?>x<?php echo e(translate('300')); ?>)
                                <span class="text-danger"
                                    title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                            </p>
                            <label for="thumbnail-one"
                                class="dropzone-wrappe file-container ac-bg text-xs leading-none font-semibold mb-3 cursor-pointer w-full h-[200px] flex flex-col items-center justify-center gap-2.5 border border-dashed border-gray-900 rounded-10 dk-theme-card-square">
                                <input type="file" hidden name="thumbnail" id="thumbnail-one"
                                    class="dropzone dropzone-image img-src peer/file">

                                <span class="flex-center flex-col peer-[.uploaded]/file:hidden">
                                    <img src="<?php echo e(asset('lms/assets/images/icons/upload-file.svg')); ?>" alt="file-icon"
                                        class="size-8 lg:size-auto">
                                    <div class="text-gray-500 dark:text-dark-text mt-2">
                                        <?php echo e(translate('Choose file')); ?> </div>
                                </span>
                            </label>
                            <div class="preview-zone dropzone-preview">
                                <div class="box box-solid">
                                    <div class="box-body flex items-center gap-2 flex-wrap">

                                        <?php if(isset($course) &&
                                                fileExists($folder = 'lms/courses/thumbnails', $fileName = $course?->thumbnail) == true &&
                                                $course?->thumbnail !== ''): ?>
                                            <div class="img-thumb-wrapper">
                                                <img class="img-thumb" width="100"
                                                    src="<?php echo e(asset('storage/lms/courses/thumbnails/' . $course->thumbnail)); ?>" />
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <span class="text-danger error-text thumbnail_err"></span>
                        </div>
                    </div>
                    <div class="card flex-center gap-4 justify-end">
                        <button type="button" class="prev-form-btn btn b-outline btn-primary-outline">
                            <?php echo e(translate('Previous')); ?>

                        </button>
                        <button type="button"
                            class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                            <?php echo e(translate('Save & Continue')); ?>

                        </button>
                    </div>
                </form>
            </div>

            <div class="fieldset">
                <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="price">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="course_id" class="courseId" value="<?php echo e($course->id ?? ''); ?>">

                    <div class="grid grid-cols-12 gap-4 card">
                        <div class="col-span-full lg:col-span-2">
                            <div class="mt-6">
                                <label for="currency" class="form-label"><?php echo e(translate('Currency')); ?>

                                    <span class="text-danger"
                                        title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                                </label>
                                <select data-select id="currency" name="currency" class="singleSelect">
                                    <option selected disabled data-display="<?php echo e(translate('Select Currency')); ?>">
                                        <?php echo e(translate('Select Currency')); ?> </option>
                                    <?php $__currentLoopData = all_currency(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $codeSymbol = $currency->code . '-' . $currency->symbol;
                                        ?>
                                        <option value="<?php echo e($currency->code . '-' . $currency->symbol); ?>"
                                            <?php echo e(isset($bundle) && $bundle?->currency == $codeSymbol ? 'selected' : ''); ?>>
                                            <?php echo e($currency->symbol); ?> - <?php echo e($currency->code); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <span class="text-danger error-text currency_err"></span>
                            </div>
                        </div>

                        <div class="col-span-full lg:col-span-3">
                            <div class="mt-6">
                                <label for="price" class="form-label"> <?php echo e(translate('Price')); ?>

                                    <span class="text-danger"
                                        title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                                </label>
                                <input type="number" placeholder="<?php echo e(translate('Your Price')); ?>"
                                    class="form-input bundle-price-cal" value="<?php echo e($bundlePrice ?? ''); ?>"
                                    id="price">

                            </div>
                        </div>
                        <div class="col-span-full lg:col-span-3">
                            <div class="mt-6">
                                <label for="platform_fee" class="form-label">
                                    <?php echo e(translate('Platform Price')); ?>

                                    <span class="text-danger"
                                        title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                                </label>

                                <input type="hidden"value="<?php echo e($platformFee ?? ''); ?>" name="platform_fee">
                                <input type="number" id="platform_fee"
                                    placeholder="<?php echo e(translate('Platform Price')); ?>" disabled
                                    class="form-input disabled:!text-heading" value="<?php echo e($platformFee ?? ''); ?>"
                                    placeholder="Platform Price">
                                <span class="text-danger error-text title_err"></span>

                            </div>
                        </div>
                        <div class="col-span-full lg:col-span-3">
                            <div class="mt-6">
                                <label for="total_price" class="form-label"><?php echo e(translate('Total Price')); ?>

                                    <span class="text-danger"
                                        title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                                </label>
                                <input type="number" id="total_price" placeholder="<?php echo e(translate('Bundle Price')); ?>"
                                    name="price" class="form-input"
                                    value="<?php echo e($bundlePrice + $platformFee ?? ''); ?>">
                                <span class="text-danger error-text  price_err"></span>
                            </div>

                        </div>
                    </div>
                    <div class="card flex-center gap-4 justify-end">
                        <button type="button" class="prev-form-btn btn b-outline btn-primary-outline">
                            <?php echo e(translate('Previous')); ?>

                        </button>
                        <button type="button"
                            class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                            <?php echo e(translate('Save & Continue')); ?>

                        </button>
                    </div>
                </form>
            </div>
            <div class="fieldset">
                <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="course">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="course_id" class="courseId" value="<?php echo e($course->id ?? ''); ?>">
                    <div class="grid grid-cols-12 gap-4 card">
                        <div class="col-span-full mt-6">
                            <label for="coupon-type" class="form-label">
                                <?php echo e(translate('Select Course')); ?>

                                <span class="text-danger"
                                    title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                            </label>
                            <select class="multipleSelect form-input" multiple="multiple" name="courseId[]">
                                <?php $__currentLoopData = get_all_course(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $courseTranslations = parse_translation($course, $locale); ?>
                                    <option value="<?php echo e($course->id); ?>"
                                        <?php if(isset($bundle) && $bundle?->courses?->count() > 0): ?> <?php $__currentLoopData = $bundle?->courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bcourse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($bcourse->id == $course->id ? 'selected' : ''); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>>
                                        <?php echo e($courseTranslations['title'] ?? ($course->title ?? '')); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <span class="text-danger error-text courseId_err"></span>
                        </div>
                    </div>
                    <div class="card flex-center gap-4 justify-end">
                        <button type="button" class="prev-form-btn btn b-outline btn-primary-outline">
                            <?php echo e(translate('Previous')); ?>

                        </button>
                        <button type="button"
                            class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                            <?php echo e(translate('Save & Continue')); ?>

                        </button>
                    </div>
                </form>
            </div>
            <div class="fieldset !block">
                <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="course">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="course_id" class="courseId" value="<?php echo e($course->id ?? ''); ?>">
                    <div class="grid grid-cols-12 gap-4 card">
                        <div class="col-span-full mt-6">
                            <label for="coupon-type" class="form-label">
                                <?php echo e(translate('Select Course')); ?>

                                <span class="text-danger"
                                    title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                            </label>
                            <select class="multipleSelect form-input" multiple="multiple" name="courseId[]">
                                <?php $__currentLoopData = get_all_course(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $courseTranslations = parse_translation($course, $locale); ?>
                                    <option value="<?php echo e($course->id); ?>"
                                        <?php if(isset($bundle) && $bundle?->courses?->count() > 0): ?> <?php $__currentLoopData = $bundle?->courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bcourse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($bcourse->id == $course->id ? 'selected' : ''); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>>
                                        <?php echo e($courseTranslations['title'] ?? ($course->title ?? '')); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <span class="text-danger error-text courseId_err"></span>
                        </div>
                    </div>
                    <div class="card flex-center gap-4 justify-end">
                        <button type="button" class="prev-form-btn btn b-outline btn-primary-outline">
                            <?php echo e(translate('Previous')); ?>

                        </button>
                        <button type="button"
                            class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                            <?php echo e(translate('Save & Continue')); ?>

                        </button>
                    </div>
                </form>
            </div>
            <div class="fieldset">
                <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="additional_information">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="course_id" class="courseId" value="<?php echo e($course->id ?? ''); ?>">
                    <!-- COURSE FAQ -->
                    <div class="card">
                        <div class="grid grid-cols-12 gap-y-5 faq-item">
                            <div class="col-span-full">
                                <div class="flex-center-between">
                                    <h6 class="leading-none text-xl font-semibold text-heading">
                                        <?php echo e(translate('Add Course FAQ')); ?>

                                    </h6>
                                    <button type="button" class="btn b-solid btn-primary-solid add-faq">
                                        <i class="ri-add-circle-line text-inherit"></i> <?php echo e(translate('Add')); ?>

                                    </button>
                                </div>
                            </div>
                            <div class="col-span-full">
                                <div class="flex flex-col gap-5 faq-area"
                                    data-length="<?php echo e(isset($course, $course->courseFaqs) ? $course->courseFaqs->count() : 0); ?>">
                                    <?php if(isset($course, $course->courseFaqs) && !empty($course->courseFaqs)): ?>
                                        <?php $__currentLoopData = $course->courseFaqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseFaq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="flex gap-4">
                                                <div class="grow flex flex-col gap-2">
                                                    <input type="hidden" name="faqs[<?php echo e($courseFaq->id); ?>][id]"
                                                        class="form-input" value="<?php echo e($courseFaq->id); ?>">

                                                    <input type="text"
                                                        placeholder="<?php echo e(translate('Faq question')); ?>"name="faqs[<?php echo e($courseFaq->id); ?>][title]"
                                                        class="form-input" value="<?php echo e($courseFaq->title); ?>">
                                                    <textarea name="faqs[<?php echo e($courseFaq->id); ?>][answer]" placeholder="<?php echo e(translate('Faq Answer')); ?>"
                                                        class="form-input"><?php echo e($courseFaq->answer); ?></textarea>
                                                </div>
                                                <button type="button"
                                                    class="btn-icon btn-danger-icon-light shrink-0 delete-btn"
                                                    data-id="<?php echo e($courseFaq->id); ?>" data-key="faq">
                                                    <i class="ri-delete-bin-line text-inherit"></i>
                                                </button>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- COURSE OUTCOME -->
                    <div class="card">
                        <div class="grid grid-cols-12 gap-y-5 outcome-item">
                            <div class="col-span-full">
                                <div class="flex-center-between">
                                    <h6 class="leading-none text-xl font-semibold text-heading">
                                        <?php echo e(translate('Add Course Outcomes')); ?> </h6>
                                    <button type="button" class="btn b-solid btn-primary-solid add-outcomes"> <i
                                            class="ri-add-circle-line text-inherit"></i> <?php echo e(translate('Add')); ?>

                                    </button>
                                </div>
                            </div>
                            <div class="col-span-full">
                                <div class="flex flex-col gap-5 outcomes-area"
                                    data-length="<?php echo e(isset($course, $course->courseOutComes) ? $course->courseOutComes->count() : 0); ?>">
                                    <?php if(isset($course, $course->courseOutComes) && !empty($course->courseOutComes)): ?>
                                        <?php $__currentLoopData = $course->courseOutComes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseOutCome): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="flex gap-4">
                                                <div class="grow flex flex-col gap-2 relative">
                                                    <input type="text"
                                                        placeholder="<?php echo e(translate('Course Outcomes')); ?>"
                                                        id="searchInput"
                                                        name="outcomes[<?php echo e($courseOutCome->id); ?>][title]"
                                                        class="form-input outcomes search-suggestion"
                                                        value="<?php echo e($courseOutCome->title); ?>"
                                                        data-search-type="outcomes">

                                                    <div class="search-show"></div>
                                                </div>
                                                <button type="button"
                                                    class="btn-icon btn-danger-icon-light shrink-0 delete-btn">
                                                    <i class="ri-delete-bin-line text-inherit"></i>
                                                </button>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- COURSE TAG -->
                    <div class="card">
                        <div class="grid grid-cols-12 gap-4">
                            <div class="col-span-full">
                                <div class="flex-center-between">
                                    <h6 class="text-xl font-semibold text-heading"> <?php echo e(translate('Course Tag')); ?>

                                    </h6>
                                </div>
                            </div>
                            <div class="col-span-full">
                                <select class="tag-list" name="tags[]" multiple="multiple">
                                    <option></option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="card flex-center gap-4 justify-end">
                        <button type="button" class="prev-form-btn btn b-outline btn-primary-outline">
                            <?php echo e(translate('Previous')); ?>

                        </button>
                        <button type="button"
                            class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                            <?php echo e(translate('Save & Continue')); ?>

                        </button>
                    </div>
                </form>
            </div>
            <div class="fieldset">
                <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="setting">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="course_id" class="courseId" value="<?php echo e($course->id ?? ''); ?>">
                    <input type="hidden" name="setting_id" value="<?php echo e($course?->courseSetting?->id ?? null); ?>">

                    <div class="grid grid-cols-12 gap-x-4">
                        <div class="col-span-full lg:col-span-6 card">
                            <h6 class="text-xl font-semibold text-heading"><?php echo e(translate('Course Settings')); ?></h6>
                            <div class="mt-10">
                                <div class="leading-none mb-10">
                                    <label for="seat"
                                        class="form-label"><?php echo e(translate('Seat Capacity')); ?></label>
                                    <input type="number" id="seat"
                                        placeholder="<?php echo e(translate('Seat Capacity')); ?>" name="seat_capacity"
                                        class="form-input"
                                        value="<?php echo e($course?->courseSetting?->seat_capacity ?? ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-span-full lg:col-span-6 card">
                            <h6 class="text-xl font-semibold text-heading"><?php echo e(translate('Course Settings Options')); ?>

                            </h6>
                            <div class="mt-10">
                                <div class="leading-none flex items-center gap-4 mb-10">
                                    <label for="support" class="inline-flex items-center me-5 cursor-pointer">
                                        <input type="checkbox" id="support" name="has_support"
                                            class="appearance-none peer"
                                            <?php echo e(isset($course) && $course?->courseSetting?->has_support == 1 ? 'checked' : ''); ?>>
                                        <div class="switcher switcher-primary-solid"></div>
                                    </label>
                                    <div class="text-gray-500 dark:text-dark-text font-medium inline-block">
                                        <?php echo e(translate('Has Support')); ?></div>
                                </div>
                                <div class="leading-none flex items-center gap-4 mb-10">
                                    <label for="certificate" class="inline-flex items-center me-5 cursor-pointer">
                                        <input type="checkbox" id="certificate" name="is_certificate"
                                            class="appearance-none peer"
                                            <?php echo e(isset($course) && $course?->courseSetting?->is_certificate == 1 ? 'checked' : ''); ?>>
                                        <div class="switcher switcher-primary-solid"></div>
                                    </label>
                                    <div class="text-gray-500 dark:text-dark-text font-medium inline-block">
                                        <?php echo e(translate('Has Certificate')); ?></div>
                                </div>

                                <div class="leading-none flex items-center gap-4 mb-10">
                                    <label for="upcoming" class="inline-flex items-center me-5 cursor-pointer">
                                        <input type="checkbox" id="upcoming" class="appearance-none peer"
                                            name="is_upcoming"
                                            <?php echo e(isset($course) && $course?->courseSetting?->is_upcoming == 1 ? 'checked' : ''); ?>>
                                        <div class="switcher switcher-primary-solid"></div>
                                    </label>
                                    <div class="text-gray-500 dark:text-dark-text font-medium inline-block">
                                        <?php echo e(translate('Is Upcoming')); ?></div>
                                </div>
                                <div class="leading-none flex items-center gap-4 mb-10">
                                    <label for="free" class="inline-flex items-center me-5 cursor-pointer">
                                        <input type="checkbox" id="free" class="appearance-none peer"
                                            name="is_free"
                                            <?php echo e(isset($course) && $course?->courseSetting?->is_free == 1 ? 'checked' : ''); ?>>
                                        <div class="switcher switcher-primary-solid"></div>
                                    </label>
                                    <div class="text-gray-500 dark:text-dark-text font-medium inline-block">
                                        <?php echo e(translate('Is Free Course')); ?></div>
                                </div>
                                <div class="leading-none flex items-center gap-4 mb-10">
                                    <label for="live" class="inline-flex items-center me-5 cursor-pointer">
                                        <input type="checkbox" id="live" class="appearance-none peer"
                                            name="is_live"
                                            <?php echo e(isset($course) && $course?->courseSetting?->is_live == 1 ? 'checked' : ''); ?>>
                                        <div class="switcher switcher-primary-solid"></div>
                                    </label>
                                    <div class="text-gray-500 dark:text-dark-text font-medium inline-block">
                                        <?php echo e(translate('Is Live')); ?></div>
                                </div>

                                <div class="leading-none flex items-center gap-4 mb-10">
                                    <label for="is_subscribe" class="inline-flex items-center me-5 cursor-pointer">
                                        <input type="checkbox" id="is_subscribe" class="appearance-none peer"
                                            name="is_subscribe"
                                            <?php echo e(isset($course) && $course?->courseSetting?->is_subscribe == 1 ? 'checked' : ''); ?>>
                                        <div class="switcher switcher-primary-solid"></div>
                                    </label>
                                    <div class="text-gray-500 dark:text-dark-text font-medium inline-block">
                                        <?php echo e(translate('Subscribe')); ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card flex-center gap-4 justify-end">
                        <button type="button"
                            class="prev-form-btn btn b-outline btn-primary-outline"><?php echo e(translate('Previous')); ?></button>
                        <button type="button"
                            class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square"><?php echo e(translate('Save & Continue')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php $__env->startPush('js'); ?>
        <script>
            $('.multipleSelect').select2({
                placeholder: "<?php echo e(translate('Select Courses')); ?>",
                width: "100%"
            })

            $('#courseCategory').select2({
                placeholder: "<?php echo e(translate('Select Courses')); ?>",
                width: "100%"
            })

            $('#courseLevel').select2({
                placeholder: "<?php echo e(translate('Select Courses')); ?>",
                width: "100%"
            })

            $('#instructorOption').select2({
                placeholder: "<?php echo e(translate('Select Courses')); ?>",
                width: "100%"
            })
        </script>
        <script src="<?php echo e(edulab_asset('lms/assets/js/component/stepper.js')); ?>"></script>
    <?php $__env->stopPush(); ?>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb)): ?>
<?php $attributes = $__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb; ?>
<?php unset($__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald7f77a02f879fd4954ea3c39c4e952cb)): ?>
<?php $component = $__componentOriginald7f77a02f879fd4954ea3c39c4e952cb; ?>
<?php unset($__componentOriginald7f77a02f879fd4954ea3c39c4e952cb); ?>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\admin\course\bundle\form.blade.php ENDPATH**/ ?>