<?php
    $isShowLanguage = $isShowLanguage ?? false;
    $textColor = $textColor ?? 'text-white';
    $loggedin = $data['loggedin'] ?? [];
    $login = $data['login'] ?? [];
    $register = $data['register'] ?? [];
    $wishlist = $data['wishlist'] ?? [];
    $cart = $data['cart'] ?? [];
    $user = authCheck()->userable ?? null;
?>


<?php if(auth()->guard()->check()): ?>
    <?php
        $url = '#';
        $wishlistUrl = '#';
        if (isOrganization()) {
            $url = route('organization.dashboard');
            $wishlistUrl = route('organization.wishlist');
        }

        if (isInstructor()) {
            $url = route('instructor.dashboard');
            $wishlistUrl = route('instructor.wishlist');
        }

        if (isStudent()) {
            $url = route('student.dashboard');
            $wishlistUrl = route('student.wishlist');
        }
    ?>
<?php endif; ?>

<?php if($isShowLanguage): ?>
    <div class="flex items-center justify-end space-x-5 divide-x divide-white/15 [&>:not(:first-child)]:pl-5 grow">
        <?php if(count(app('languages')) > 0): ?>
            <div class="flex items-center">
                <form method="get" action="<?php echo e(route('language.set')); ?>" id="language-form">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="admin_id"
                        value="<?php echo e(auth('admin')->check() ? auth('admin')->user()->id : null); ?>">
                    <input type="hidden" name="user_id" value="<?php echo e(auth()->check() ? auth()->user()->id : null); ?>">
                    <select name="locale" aria-label="Choose Language"
                        onchange="event.preventDefault();
                    document.getElementById('language-form').submit();"
                        class="<?php echo e($textColor); ?> *:text-heading dark:text-white font-semibold bg-transparent focus:outline-none cursor-pointer select-none text-sm bg-heading">
                        <?php $__currentLoopData = app('languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($language->code); ?>"
                                <?php echo e(app()->getLocale() == $language->code ? 'selected' : ''); ?>>
                                <?php echo e($language->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </form>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>

<?php if($wishlist['is_show'] ?? true): ?>
    <a href="<?php echo e($wishlistUrl ?? '#'); ?>" aria-label="Wishlist icon"
        class="<?php echo e($wishlist['link_class'] ?? 'relative hidden md:flex-center text-white px-2 py-3 shrink-0'); ?>">
        <img data-src="<?php echo e($wishlist['icon_image'] ?? asset('lms/frontend/assets/images/icons/wish-list.svg')); ?>"
            alt="Icon">
        <span
            class="total-wishlist <?php echo e($wishlist['badge_class'] ?? 'flex-center size-6 rounded-50 bg-primary text-xs text-white border-2 border-white absolute top-0 -right-1 rtl:right-auto rtl:-left-1'); ?> ">
            <?php if(auth()->guard()->check()): ?>
                <?php echo e(count(authCheck()?->wishlists)); ?>

            <?php else: ?>
                0
            <?php endif; ?>
        </span>
    </a>
<?php endif; ?>
<!-- CART LIST -->
<?php if($cart['is_show'] ?? true): ?>
    <a href="<?php echo e($cart['url'] ?? route('cart.page')); ?>" aria-label="Cart icon"
        class="relative hidden md:flex text-heading px-2 py-3 shrink-0">
        <img data-src="<?php echo e($cart['icon_image'] ?? asset('lms/frontend/assets/images/icons/cart.svg')); ?>" alt="Icon">
        <span
            class="<?php echo e($cart['badge_class'] ?? 'flex-center size-6 rounded-50 bg-primary text-xs text-white border-2 border-white absolute top-0 -right-1 rtl:right-auto rtl:-left-1 total-qty'); ?>"><?php echo e(total_qty()); ?></span>
    </a>
<?php endif; ?>
<!-- ACTION LINK -->
<div class="flex gap-4 shrink-0">
    <?php if(auth()->guard()->check()): ?>
        <a href="<?php echo e($url); ?>" aria-label="Profile info"
            class="<?php echo e($loggedin['link_class'] ?? 'btn b-outline btn-secondary-outline h-11 !rounded-full !text-heading font-semibold'); ?>">
            <span class="hidden md:block"><i class="ri-user-3-line"></i></span>
            <?php echo e($user?->name ?? $user->first_name); ?>

        </a>
    <?php else: ?>
        <?php if(Auth::guard('admin')->check()): ?>
            <a href="<?php echo e(route('admin.dashboard')); ?>" aria-label="Profile info"
                class="<?php echo e($loggedin['link_class'] ?? 'btn b-outline btn-secondary-outline h-11 !rounded-full !text-heading font-semibold'); ?>">
                <span class="hidden md:block"><i class="ri-user-3-line"></i></span>
                <?php echo e(auth('admin')->user()->name); ?>

            </a>
        <?php elseif($login['is_show'] ?? true): ?>
            <a href="<?php echo e($login['url'] ?? route('login')); ?>" aria-label="Log in"
                class="<?php echo e($login['link_class'] ?? 'flex btn b-outline btn-secondary-outline h-11 !rounded-full !text-heading font-semibold'); ?>">
                <span class="hidden md:block"><i class="ri-user-3-line"></i></span>
                <?php echo e(translate($login['label'] ?? 'Log In')); ?>

            </a>
        <?php endif; ?>
    <?php endif; ?>
    <?php if(!Auth::guard('admin')->check() && !Auth::guard('web')->check() && ($register['is_show'] ?? true)): ?>
        <a href="<?php echo e($register['url'] ?? route('auth.register')); ?>" aria-label="Registration"
            class="<?php echo e($register['link_class'] ?? 'hidden md:flex btn b-solid btn-secondary-solid h-11 !rounded-full !text-heading font-semibold'); ?>">
            <?php echo e(translate($register['label'] ?? 'Sign up')); ?>

            <?php if($register['show_icon'] ?? true): ?>
                <span class="hidden md:block">
                    <i class="<?php echo e($register['link_icon'] ?? 'ri-arrow-right-up-line'); ?>"></i>
                </span>
            <?php endif; ?>
        </a>
    <?php endif; ?>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\header\right-side.blade.php ENDPATH**/ ?>